/*
 * Decompiled with CFR 0.152.
 */
package org.atmosphere.cpr;

import java.util.Collection;
import java.util.Collections;
import java.util.Enumeration;
import java.util.Random;
import java.util.concurrent.ConcurrentHashMap;
import java.util.logging.Level;
import org.atmosphere.cpr.Broadcaster;
import org.atmosphere.cpr.BroadcasterConfig;
import org.atmosphere.cpr.BroadcasterFactory;
import org.atmosphere.util.LoggerUtils;

public class DefaultBroadcasterFactory
extends BroadcasterFactory {
    private final ConcurrentHashMap<Object, Broadcaster> store = new ConcurrentHashMap();
    private static BroadcasterFactory factory;
    private final Class<? extends Broadcaster> clazz;
    private final BroadcasterConfig config;

    protected DefaultBroadcasterFactory(Class<? extends Broadcaster> clazz, BroadcasterConfig config) {
        this.clazz = clazz;
        this.config = config;
        if (factory == null) {
            factory = this;
        }
    }

    @Override
    public Broadcaster get() throws IllegalAccessException, InstantiationException {
        Broadcaster b = this.clazz.newInstance();
        b.setBroadcasterConfig(this.config);
        b.setID(this.clazz.getSimpleName() + "-" + new Random().nextInt());
        this.store.put(b.getID(), b);
        return b;
    }

    @Override
    public final Broadcaster get(Class<? extends Broadcaster> c, Object id) throws IllegalAccessException, InstantiationException {
        if (id == null) {
            throw new NullPointerException("id is null");
        }
        if (c == null) {
            throw new NullPointerException("Class is null");
        }
        Broadcaster b = c.newInstance();
        b.setBroadcasterConfig(this.config);
        b.setID(id.toString());
        this.store.put(id, b);
        return b;
    }

    private Broadcaster getBroadcaster(Object name) {
        return this.store.get(name);
    }

    @Override
    public boolean add(Broadcaster b, Object id) {
        return this.store.put(id, b) == null;
    }

    @Override
    public boolean remove(Broadcaster b, Object id) {
        return this.store.remove(id) != null;
    }

    @Override
    public final Broadcaster lookup(Class<? extends Broadcaster> c, Object id) {
        return this.lookup(c, id, false);
    }

    @Override
    public Broadcaster lookup(Class<? extends Broadcaster> c, Object id, boolean createIfNull) {
        Broadcaster b = this.getBroadcaster(id);
        if (b != null && !c.isAssignableFrom(b.getClass())) {
            String em = "Invalid lookup class " + c.getName() + ". Cached class is: " + b.getClass().getName();
            if (LoggerUtils.getLogger().isLoggable(Level.FINE)) {
                LoggerUtils.getLogger().log(Level.FINE, em);
            }
            throw new IllegalStateException(em);
        }
        if (b == null && createIfNull) {
            try {
                b = this.get(c, id);
            }
            catch (IllegalAccessException e) {
                throw new IllegalStateException(e);
            }
            catch (InstantiationException e) {
                throw new IllegalStateException(e);
            }
        }
        return b;
    }

    @Override
    public Collection<Broadcaster> lookupAll() {
        return Collections.unmodifiableCollection(this.store.values());
    }

    @Override
    public void destroy() {
        Enumeration<Broadcaster> e = this.store.elements();
        while (e.hasMoreElements()) {
            e.nextElement().destroy();
        }
        this.store.clear();
        factory = null;
    }

    public static BroadcasterFactory build(Class<? extends Broadcaster> clazz, BroadcasterConfig config) throws InstantiationException, IllegalAccessException {
        return new DefaultBroadcasterFactory(clazz, config);
    }

    public static BroadcasterFactory buildAndReplaceDefaultfactory(Class<? extends Broadcaster> clazz, BroadcasterConfig config) throws InstantiationException, IllegalAccessException {
        factory = new DefaultBroadcasterFactory(clazz, config);
        return factory;
    }
}

