/*
 * Decompiled with CFR 0.152.
 */
package org.atmosphere.container;

import java.io.IOException;
import java.util.concurrent.ConcurrentLinkedQueue;
import java.util.logging.Level;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.atmosphere.cpr.AsynchronousProcessor;
import org.atmosphere.cpr.AtmosphereResourceImpl;
import org.atmosphere.cpr.AtmosphereServlet;
import org.atmosphere.cpr.CometSupport;
import org.mortbay.util.ajax.Continuation;
import org.mortbay.util.ajax.ContinuationSupport;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class JettyCometSupport
extends AsynchronousProcessor
implements CometSupport<AtmosphereResourceImpl> {
    private final ConcurrentLinkedQueue<Continuation> resumed = new ConcurrentLinkedQueue();

    public JettyCometSupport(AtmosphereServlet.AtmosphereConfig config) {
        super(config);
    }

    @Override
    public AtmosphereServlet.Action service(HttpServletRequest req, HttpServletResponse res) throws IOException, ServletException {
        Continuation c = ContinuationSupport.getContinuation((HttpServletRequest)req, null);
        AtmosphereServlet.Action action = null;
        if (!c.isResumed() && !c.isPending()) {
            action = this.suspended(req, res);
            if (action.type == AtmosphereServlet.Action.TYPE.SUSPEND) {
                if (this.logger.isLoggable(Level.FINE)) {
                    this.logger.fine("Suspending " + res);
                }
                if (action.timeout != -1L) {
                    c.suspend(action.timeout);
                } else {
                    c.suspend(0L);
                }
            }
        } else {
            if (this.logger.isLoggable(Level.FINE)) {
                this.logger.fine("Resuming " + res);
            }
            if (!this.resumed.remove(c)) {
                c.reset();
                if (req.getAttribute(AtmosphereResourceImpl.RESUMED_ON_TIMEOUT) == null) {
                    this.timedout(req, res);
                } else {
                    this.resumed(req, res);
                }
            }
        }
        return action;
    }

    @Override
    public void action(AtmosphereResourceImpl actionEvent) {
        super.action(actionEvent);
        if (actionEvent.action().type == AtmosphereServlet.Action.TYPE.RESUME) {
            Continuation c = ContinuationSupport.getContinuation((HttpServletRequest)actionEvent.getRequest(), null);
            this.resumed.offer(c);
            c.resume();
        }
    }
}

