/*
 * Decompiled with CFR 0.152.
 */
package org.atmosphere.cpr;

import java.io.IOException;
import java.util.Iterator;
import java.util.Set;
import java.util.concurrent.BlockingQueue;
import java.util.concurrent.Callable;
import java.util.concurrent.ConcurrentLinkedQueue;
import java.util.concurrent.Future;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.logging.Level;
import org.atmosphere.cpr.AtmosphereEventLifecycle;
import org.atmosphere.cpr.AtmosphereResource;
import org.atmosphere.cpr.AtmosphereResourceEvent;
import org.atmosphere.cpr.AtmosphereResourceEventImpl;
import org.atmosphere.cpr.AtmosphereResourceImpl;
import org.atmosphere.cpr.BroadcastFilter;
import org.atmosphere.cpr.Broadcaster;
import org.atmosphere.cpr.BroadcasterConfig;
import org.atmosphere.cpr.BroadcasterFuture;
import org.atmosphere.util.BroadcasterLookup;
import org.atmosphere.util.LoggerUtils;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DefaultBroadcaster
implements Broadcaster {
    protected final ConcurrentLinkedQueue<AtmosphereResource> events = new ConcurrentLinkedQueue();
    protected BroadcasterConfig bc;
    protected final BlockingQueue<Entry> messages = new LinkedBlockingQueue<Entry>();
    protected final AtomicBoolean started = new AtomicBoolean(false);
    protected Broadcaster.SCOPE scope = Broadcaster.SCOPE.APPLICATION;
    protected String name = DefaultBroadcaster.class.getSimpleName();
    protected final ConcurrentLinkedQueue<Entry> delayedBroadcast = new ConcurrentLinkedQueue();

    public DefaultBroadcaster() {
        this(new BroadcasterConfig(), DefaultBroadcaster.class.getSimpleName());
    }

    public DefaultBroadcaster(String name) {
        this(new BroadcasterConfig(), name);
    }

    public DefaultBroadcaster(BroadcasterConfig bc, String name) {
        this.name = name;
        this.bc = bc;
        BroadcasterLookup.add(this, name);
    }

    @Override
    public void destroy() {
        this.bc.destroy();
    }

    @Override
    public Iterator<AtmosphereResource> getAtmosphereResources() {
        return this.events.iterator();
    }

    @Override
    public void setScope(Broadcaster.SCOPE scope) {
        this.scope = scope;
    }

    @Override
    public Broadcaster.SCOPE getScope() {
        return this.scope;
    }

    @Override
    public void setID(String id) {
        BroadcasterLookup.remove(this, this.name);
        this.name = id;
        BroadcasterLookup.add(this, this.name);
    }

    @Override
    public String getID() {
        return this.name;
    }

    @Override
    public void resumeAll() {
        for (AtmosphereResource r : this.events) {
            r.resume();
        }
    }

    protected void start() {
        if (!this.started.getAndSet(true)) {
            this.bc.getExecutorService().submit(new Runnable(){

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                public void run() {
                    Entry msg = null;
                    try {
                        msg = DefaultBroadcaster.this.messages.take();
                        DefaultBroadcaster.this.bc.getExecutorService().submit(this);
                        if (!DefaultBroadcaster.this.delayedBroadcast.isEmpty()) {
                            Iterator<Entry> i = DefaultBroadcaster.this.delayedBroadcast.iterator();
                            while (i.hasNext()) {
                                Entry e = i.next();
                                if (!(e.f instanceof BroadcasterFuture)) {
                                    e.f.cancel(true);
                                }
                                try {
                                    if (e.message instanceof String && msg.message instanceof String) {
                                        msg.message = e.message.toString() + msg.message.toString();
                                        continue;
                                    }
                                    DefaultBroadcaster.this.push(e);
                                }
                                finally {
                                    i.remove();
                                    if (e.f instanceof BroadcasterFuture) {
                                        ((BroadcasterFuture)e.f).done();
                                    }
                                }
                            }
                        }
                        DefaultBroadcaster.this.push(msg);
                    }
                    catch (InterruptedException ex) {
                        LoggerUtils.getLogger().log(Level.SEVERE, null, ex);
                    }
                    finally {
                        if (msg.f instanceof BroadcasterFuture) {
                            ((BroadcasterFuture)msg.f).done();
                        } else {
                            msg.f.cancel(true);
                        }
                    }
                }
            });
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void push(Entry msg) {
        block19: {
            AtmosphereResourceEventImpl e;
            block18: {
                e = null;
                if (msg.eventsToPush != null) break block18;
                Iterator<AtmosphereResource> i$ = this.events.iterator();
                while (i$.hasNext()) {
                    AtmosphereResource r2;
                    AtmosphereResource atmosphereResource = r2 = i$.next();
                    synchronized (atmosphereResource) {
                        if (r2 instanceof AtmosphereResourceImpl) {
                            e = ((AtmosphereResourceImpl)r2).event();
                            e.setMessage(msg.message);
                        }
                        this.broadcast(r2, e);
                        if (r2 instanceof AtmosphereEventLifecycle) {
                            ((AtmosphereEventLifecycle)((Object)r2)).notifyListeners();
                        }
                    }
                }
                break block19;
            }
            if (msg.eventsToPush instanceof AtmosphereResource) {
                AtmosphereResource r;
                AtmosphereResource r2 = r = (AtmosphereResource)msg.eventsToPush;
                synchronized (r2) {
                    if (r instanceof AtmosphereResourceImpl) {
                        e = ((AtmosphereResourceImpl)r).event();
                        e.setMessage(msg.message);
                    }
                    this.broadcast(r, e);
                    if (r instanceof AtmosphereEventLifecycle) {
                        ((AtmosphereEventLifecycle)((Object)r)).notifyListeners();
                    }
                }
            }
            if (!(msg.eventsToPush instanceof Set)) break block19;
            Set sub = (Set)msg.eventsToPush;
            Iterator i$ = sub.iterator();
            while (i$.hasNext()) {
                AtmosphereResource r;
                AtmosphereResource atmosphereResource = r = (AtmosphereResource)i$.next();
                synchronized (atmosphereResource) {
                    if (r instanceof AtmosphereResourceImpl) {
                        e = ((AtmosphereResourceImpl)r).event();
                        e.setMessage(msg.message);
                    }
                    this.broadcast(r, e);
                    if (r instanceof AtmosphereEventLifecycle) {
                        ((AtmosphereEventLifecycle)((Object)r)).notifyListeners();
                    }
                }
            }
        }
    }

    protected void broadcast(AtmosphereResource r, AtmosphereResourceEvent e) {
        try {
            r.getAtmosphereConfig().getAtmosphereHandler().onStateChange(e);
        }
        catch (IOException ex) {
            this.onException(ex, r);
        }
        catch (IllegalStateException ex) {
            this.onException(ex, r);
        }
    }

    protected void onException(Throwable t, AtmosphereResource r) {
        if (LoggerUtils.getLogger().isLoggable(Level.FINE)) {
            LoggerUtils.getLogger().log(Level.FINE, "", t);
        }
        if (t instanceof IOException && r instanceof AtmosphereEventLifecycle) {
            ((AtmosphereEventLifecycle)((Object)r)).notifyListeners(new AtmosphereResourceEventImpl((AtmosphereResourceImpl)r, true, false));
            ((AtmosphereEventLifecycle)((Object)r)).removeEventListeners();
        }
        this.removeAtmosphereResource(r);
    }

    public BroadcasterFuture<Object> broadcast(Object msg) {
        this.start();
        msg = this.filter(msg);
        if (msg == null) {
            return null;
        }
        BroadcasterFuture<Object> f = new BroadcasterFuture<Object>(msg);
        this.messages.offer(new Entry(msg, null, f));
        return f;
    }

    protected Object filter(Object msg) {
        BroadcastFilter.BroadcastAction a = this.bc.filter(msg);
        if (a.action() == BroadcastFilter.BroadcastAction.ACTION.ABORT || msg == null) {
            return null;
        }
        return a.message();
    }

    public BroadcasterFuture<Object> broadcast(Object msg, AtmosphereResource r) {
        this.start();
        msg = this.filter(msg);
        if (msg == null) {
            return null;
        }
        BroadcasterFuture<Object> f = new BroadcasterFuture<Object>(msg);
        this.messages.offer(new Entry(msg, r, f));
        return f;
    }

    public BroadcasterFuture<Object> broadcast(Object msg, Set<AtmosphereResource> subset) {
        this.start();
        msg = this.filter(msg);
        if (msg == null) {
            return null;
        }
        BroadcasterFuture<Object> f = new BroadcasterFuture<Object>(msg);
        this.messages.offer(new Entry(msg, subset, f));
        return f;
    }

    @Override
    public AtmosphereResource addAtmosphereResource(AtmosphereResource r) {
        if (this.events.contains(r)) {
            return null;
        }
        this.events.offer(r);
        return r;
    }

    @Override
    public AtmosphereResource removeAtmosphereResource(AtmosphereResource r) {
        if (!this.events.contains(r)) {
            return null;
        }
        this.events.remove(r);
        return r;
    }

    protected ConcurrentLinkedQueue<AtmosphereResource> atmosphereResources() {
        return this.events;
    }

    @Override
    public void setBroadcasterConfig(BroadcasterConfig bc) {
        this.bc = bc;
    }

    @Override
    public BroadcasterConfig getBroadcasterConfig() {
        return this.bc;
    }

    @Override
    public Future<Object> delayBroadcast(Object o) {
        return this.delayBroadcast(o, 0L, null);
    }

    @Override
    public Future<Object> delayBroadcast(Object o, long delay, TimeUnit t) {
        final Object msg = this.filter(o);
        if (msg == null) {
            return null;
        }
        Future f = new BroadcasterFuture<Object>(msg);
        final Entry e = new Entry(msg, null, f);
        if (delay > 0L) {
            e.f = f = this.bc.getScheduledExecutorService().schedule(new Callable<Object>(){

                @Override
                public Object call() throws Exception {
                    DefaultBroadcaster.this.delayedBroadcast.remove(e);
                    DefaultBroadcaster.this.push(e);
                    return msg;
                }
            }, delay, t);
        }
        this.delayedBroadcast.offer(e);
        return f;
    }

    @Override
    public Future<?> scheduleFixedBroadcast(Object o, long period, TimeUnit t) {
        return this.scheduleFixedBroadcast(o, 0L, period, t);
    }

    @Override
    public Future<?> scheduleFixedBroadcast(Object o, long waitFor, long period, TimeUnit t) {
        if (period == 0L || t == null) {
            return null;
        }
        Object msg = this.filter(o);
        if (msg == null) {
            return null;
        }
        final Entry e = new Entry(o, null, null);
        return this.bc.getScheduledExecutorService().scheduleWithFixedDelay(new Runnable(){

            public void run() {
                DefaultBroadcaster.this.push(e);
            }
        }, waitFor, period, t);
    }

    public class Entry {
        public Object message;
        public Object eventsToPush;
        public Future f;

        public Entry(Object message, Object eventsToPush, Future f) {
            this.message = message;
            this.eventsToPush = eventsToPush;
            this.f = f;
        }
    }
}

