/*
 * Decompiled with CFR 0.152.
 */
package org.atmosphere.annotation;

import java.util.ArrayList;
import org.atmosphere.annotation.AnnotationUtil;
import org.atmosphere.annotation.Processor;
import org.atmosphere.config.AtmosphereAnnotation;
import org.atmosphere.config.managed.ManagedAtmosphereHandler;
import org.atmosphere.config.managed.ManagedServiceInterceptor;
import org.atmosphere.config.service.ManagedService;
import org.atmosphere.cpr.AtmosphereFramework;
import org.atmosphere.cpr.AtmosphereHandler;
import org.atmosphere.cpr.AtmosphereInterceptor;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@AtmosphereAnnotation(value=ManagedService.class)
public class ManagedServiceProcessor
implements Processor {
    private static final Logger logger = LoggerFactory.getLogger(ManagedServiceProcessor.class);

    @Override
    public void handle(AtmosphereFramework framework, Class<?> annotatedClass) {
        try {
            Class[] interceptors;
            Class<?> aClass = annotatedClass;
            ManagedService a = aClass.getAnnotation(ManagedService.class);
            framework.setBroadcasterCacheClassName(a.broadcasterCache().getName());
            ArrayList<Object> l = new ArrayList<Object>();
            AnnotationUtil.atmosphereConfig(a.atmosphereConfig(), framework);
            framework.setDefaultBroadcasterClassName(a.broadcaster().getName());
            AnnotationUtil.filters(a.broadcastFilters(), framework);
            AtmosphereInterceptor aa = AnnotationUtil.listeners(a.listeners(), framework);
            if (aa != null) {
                l.add(aa);
            }
            Object c = aClass.newInstance();
            ManagedAtmosphereHandler handler = new ManagedAtmosphereHandler(c);
            l.add(new ManagedServiceInterceptor());
            for (Class i : interceptors = a.interceptors()) {
                try {
                    l.add((AtmosphereInterceptor)i.newInstance());
                }
                catch (Throwable e) {
                    logger.warn("", e);
                }
            }
            framework.addAtmosphereHandler(a.path(), (AtmosphereHandler)handler, l);
        }
        catch (Throwable e) {
            logger.warn("", e);
        }
    }
}

