/*
 * Decompiled with CFR 0.152.
 */
package org.atmosphere.annotation;

import java.io.IOException;
import java.util.LinkedList;
import javax.servlet.ServletConfig;
import javax.servlet.ServletException;
import org.atmosphere.annotation.AnnotationUtil;
import org.atmosphere.annotation.Processor;
import org.atmosphere.config.AtmosphereAnnotation;
import org.atmosphere.config.service.AtmosphereService;
import org.atmosphere.cpr.ApplicationConfig;
import org.atmosphere.cpr.AtmosphereFramework;
import org.atmosphere.cpr.AtmosphereHandler;
import org.atmosphere.cpr.AtmosphereInterceptor;
import org.atmosphere.cpr.AtmosphereResource;
import org.atmosphere.cpr.AtmosphereResourceEvent;
import org.atmosphere.cpr.AtmosphereServletProcessor;
import org.atmosphere.handler.ReflectorServletProcessor;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@AtmosphereAnnotation(value=AtmosphereService.class)
public class AtmosphereServiceProcessor
implements Processor {
    private static final Logger logger = LoggerFactory.getLogger(AtmosphereServiceProcessor.class);

    @Override
    public void handle(AtmosphereFramework framework, Class<?> annotatedClass) {
        try {
            Class<?> aClass = annotatedClass;
            AtmosphereService a = aClass.getAnnotation(AtmosphereService.class);
            AnnotationUtil.atmosphereConfig(a.atmosphereConfig(), framework);
            framework.setDefaultBroadcasterClassName(a.broadcaster().getName());
            AnnotationUtil.filters(a.broadcastFilters(), framework);
            LinkedList<AtmosphereInterceptor> l = new LinkedList<AtmosphereInterceptor>();
            AtmosphereInterceptor aa = AnnotationUtil.listeners(a.listeners(), framework);
            if (aa != null) {
                l.add(aa);
            }
            if (!a.servlet().isEmpty()) {
                Class[] interceptors;
                final ReflectorServletProcessor r = new ReflectorServletProcessor();
                r.setServletClassName(a.servlet());
                String mapping = a.path();
                for (Class i : interceptors = a.interceptors()) {
                    try {
                        AtmosphereInterceptor ai = (AtmosphereInterceptor)i.newInstance();
                        l.add(ai);
                    }
                    catch (Throwable e) {
                        logger.warn("", e);
                    }
                }
                if (!a.dispatch()) {
                    AtmosphereServletProcessor proxy = new AtmosphereServletProcessor(){
                        private String method = "GET";

                        public void onRequest(AtmosphereResource resource) throws IOException {
                            if (!resource.getRequest().getMethod().equalsIgnoreCase(this.method)) {
                                r.onRequest(resource);
                            }
                        }

                        public void onStateChange(AtmosphereResourceEvent event) throws IOException {
                            r.onStateChange(event);
                        }

                        public void destroy() {
                            r.destroy();
                        }

                        public void init(ServletConfig sc) throws ServletException {
                            String s = sc.getInitParameter(ApplicationConfig.ATMOSPHERERESOURCE_INTERCEPTOR_METHOD);
                            if (s != null) {
                                this.method = s;
                            }
                            r.init(sc);
                        }
                    };
                    framework.addAtmosphereHandler(mapping, (AtmosphereHandler)proxy, l);
                } else {
                    framework.addAtmosphereHandler(mapping, (AtmosphereHandler)r, l);
                }
            } else {
                AnnotationUtil.interceptors(a.interceptors(), framework);
            }
            framework.setBroadcasterCacheClassName(a.broadcasterCache().getName());
        }
        catch (Throwable e) {
            logger.warn("", e);
        }
    }
}

