/*
 * Decompiled with CFR 0.152.
 */
package io.netty.resolver.dns;

import io.netty.bootstrap.ChannelFactory;
import io.netty.channel.EventLoop;
import io.netty.channel.ReflectiveChannelFactory;
import io.netty.channel.socket.DatagramChannel;
import io.netty.channel.socket.InternetProtocolFamily;
import io.netty.resolver.HostsFileEntriesResolver;
import io.netty.resolver.dns.DefaultDnsCache;
import io.netty.resolver.dns.DnsCache;
import io.netty.resolver.dns.DnsNameResolver;
import io.netty.resolver.dns.DnsServerAddresses;
import io.netty.util.internal.ObjectUtil;
import io.netty.util.internal.ObjectUtil2;
import java.net.InetSocketAddress;
import java.util.ArrayList;

public abstract class DnsNameResolverBuilder<T extends DnsNameResolverBuilder<T>> {
    protected final EventLoop eventLoop;
    protected ChannelFactory<? extends DatagramChannel> channelFactory;
    protected InetSocketAddress localAddress = DnsNameResolver.ANY_LOCAL_ADDR;
    protected DnsServerAddresses nameServerAddresses = DnsServerAddresses.defaultAddresses();
    protected DnsCache resolveCache;
    protected Integer minTtl;
    protected Integer maxTtl;
    protected Integer negativeTtl;
    protected long queryTimeoutMillis = 5000L;
    protected InternetProtocolFamily[] resolvedAddressTypes = DnsNameResolver.DEFAULT_RESOLVE_ADDRESS_TYPES;
    protected boolean recursionDesired = true;
    protected int maxQueriesPerResolve = 3;
    protected boolean traceEnabled;
    protected int maxPayloadSize = 4096;
    protected boolean optResourceEnabled = true;
    protected HostsFileEntriesResolver hostsFileEntriesResolver = HostsFileEntriesResolver.DEFAULT;

    public DnsNameResolverBuilder(EventLoop eventLoop) {
        this.eventLoop = eventLoop;
    }

    private T cast() {
        return (T)this;
    }

    public T channelFactory(ChannelFactory<? extends DatagramChannel> channelFactory) {
        this.channelFactory = channelFactory;
        return this.cast();
    }

    public T channelType(Class<? extends DatagramChannel> channelType) {
        return this.channelFactory(new ReflectiveChannelFactory<DatagramChannel>(channelType));
    }

    public T localAddress(InetSocketAddress localAddress) {
        this.localAddress = localAddress;
        return this.cast();
    }

    public T nameServerAddresses(DnsServerAddresses nameServerAddresses) {
        this.nameServerAddresses = nameServerAddresses;
        return this.cast();
    }

    public T resolveCache(DnsCache resolveCache) {
        this.resolveCache = resolveCache;
        return this.cast();
    }

    public T ttl(int minTtl, int maxTtl) {
        this.maxTtl = maxTtl;
        this.minTtl = minTtl;
        return this.cast();
    }

    public T negativeTtl(int negativeTtl) {
        this.negativeTtl = negativeTtl;
        return this.cast();
    }

    public T queryTimeoutMillis(long queryTimeoutMillis) {
        this.queryTimeoutMillis = queryTimeoutMillis;
        return this.cast();
    }

    public T resolvedAddressTypes(InternetProtocolFamily ... resolvedAddressTypes) {
        ObjectUtil.checkNotNull(resolvedAddressTypes, "resolvedAddressTypes");
        ArrayList<InternetProtocolFamily> list = new ArrayList<InternetProtocolFamily>(InternetProtocolFamily.values().length);
        for (InternetProtocolFamily f : resolvedAddressTypes) {
            if (f == null) break;
            if (list.contains(f)) continue;
            list.add(f);
        }
        if (list.isEmpty()) {
            throw new IllegalArgumentException("no protocol family specified");
        }
        this.resolvedAddressTypes = list.toArray(new InternetProtocolFamily[list.size()]);
        return this.cast();
    }

    public T resolvedAddressTypes(Iterable<InternetProtocolFamily> resolvedAddressTypes) {
        ObjectUtil.checkNotNull(resolvedAddressTypes, "resolveAddressTypes");
        ArrayList<InternetProtocolFamily> list = new ArrayList<InternetProtocolFamily>(InternetProtocolFamily.values().length);
        for (InternetProtocolFamily f : resolvedAddressTypes) {
            if (f == null) break;
            if (list.contains(f)) continue;
            list.add(f);
        }
        if (list.isEmpty()) {
            throw new IllegalArgumentException("no protocol family specified");
        }
        this.resolvedAddressTypes = list.toArray(new InternetProtocolFamily[list.size()]);
        return this.cast();
    }

    public T recursionDesired(boolean recursionDesired) {
        this.recursionDesired = recursionDesired;
        return this.cast();
    }

    public T maxQueriesPerResolve(int maxQueriesPerResolve) {
        this.maxQueriesPerResolve = maxQueriesPerResolve;
        return this.cast();
    }

    public T traceEnabled(boolean traceEnabled) {
        this.traceEnabled = traceEnabled;
        return this.cast();
    }

    public T maxPayloadSize(int maxPayloadSize) {
        this.maxPayloadSize = maxPayloadSize;
        return this.cast();
    }

    public T optResourceEnabled(boolean optResourceEnabled) {
        this.optResourceEnabled = optResourceEnabled;
        return this.cast();
    }

    public T hostsFileEntriesResolver(HostsFileEntriesResolver hostsFileEntriesResolver) {
        this.hostsFileEntriesResolver = hostsFileEntriesResolver;
        return this.cast();
    }

    public DnsNameResolver build() {
        if (this.resolveCache != null && (this.minTtl != null || this.maxTtl != null || this.negativeTtl != null)) {
            throw new IllegalStateException("resolveCache and TTLs are mutually exclusive");
        }
        DnsCache cache = this.resolveCache != null ? this.resolveCache : new DefaultDnsCache(ObjectUtil2.intValue(this.minTtl, 0), ObjectUtil2.intValue(this.maxTtl, Integer.MAX_VALUE), ObjectUtil2.intValue(this.negativeTtl, 0));
        return this.build0(cache);
    }

    protected abstract DnsNameResolver build0(DnsCache var1);
}

