/*
 * Decompiled with CFR 0.152.
 */
package org.assertj.guava.api;

import com.google.common.collect.Lists;
import com.google.common.collect.Multimap;
import com.google.common.collect.Sets;
import java.util.ArrayList;
import java.util.LinkedHashSet;
import java.util.Objects;
import java.util.Set;
import org.assertj.core.api.AbstractAssert;
import org.assertj.core.data.MapEntry;
import org.assertj.core.error.ShouldBeEmpty;
import org.assertj.core.error.ShouldContain;
import org.assertj.core.error.ShouldContainOnly;
import org.assertj.core.error.ShouldHaveSize;
import org.assertj.core.error.ShouldNotBeEmpty;
import org.assertj.core.error.ShouldNotContainKeys;
import org.assertj.guava.error.ShouldContainKeys;
import org.assertj.guava.error.ShouldContainValues;
import org.assertj.guava.util.ExceptionUtils;

public class MultimapAssert<K, V>
extends AbstractAssert<MultimapAssert<K, V>, Multimap<K, V>> {
    protected MultimapAssert(Multimap<K, V> actual) {
        super(actual, MultimapAssert.class);
    }

    protected Multimap<K, V> getActual() {
        return (Multimap)this.actual;
    }

    public MultimapAssert<K, V> containsKeys(K ... keys) {
        this.isNotNull();
        ExceptionUtils.throwIllegalArgumentExceptionIfTrue(keys == null, "The keys to look for should not be null", new Object[0]);
        ExceptionUtils.throwIllegalArgumentExceptionIfTrue(keys.length == 0, "The keys to look for should not be empty", new Object[0]);
        LinkedHashSet keysNotFound = Sets.newLinkedHashSet();
        for (K key : keys) {
            if (((Multimap)this.actual).containsKey(key)) continue;
            keysNotFound.add(key);
        }
        if (!keysNotFound.isEmpty()) {
            throw this.assertionError(ShouldContainKeys.shouldContainKeys(this.actual, keys, keysNotFound));
        }
        return (MultimapAssert)this.myself;
    }

    @SafeVarargs
    public final MultimapAssert<K, V> contains(MapEntry<K, V> ... entries) {
        this.isNotNull();
        ExceptionUtils.throwIllegalArgumentExceptionIfTrue(entries == null, "The entries to look for should not be null", new Object[0]);
        ExceptionUtils.throwIllegalArgumentExceptionIfTrue(entries.length == 0, "The entries to look for should not be empty", new Object[0]);
        ArrayList entriesNotFound = Lists.newArrayList();
        for (MapEntry<K, V> entry : entries) {
            if (((Multimap)this.actual).containsEntry(entry.key, entry.value)) continue;
            entriesNotFound.add(entry);
        }
        if (!entriesNotFound.isEmpty()) {
            throw this.assertionError(ShouldContain.shouldContain((Object)this.actual, entries, (Object)entriesNotFound));
        }
        return (MultimapAssert)this.myself;
    }

    public MultimapAssert<K, V> containsValues(V ... values) {
        this.isNotNull();
        ExceptionUtils.throwIllegalArgumentExceptionIfTrue(values == null, "The values to look for should not be null", new Object[0]);
        ExceptionUtils.throwIllegalArgumentExceptionIfTrue(values.length == 0, "The values to look for should not be empty", new Object[0]);
        LinkedHashSet valuesNotFound = Sets.newLinkedHashSet();
        for (V value : values) {
            if (((Multimap)this.actual).containsValue(value)) continue;
            valuesNotFound.add(value);
        }
        if (!valuesNotFound.isEmpty()) {
            throw this.assertionError(ShouldContainValues.shouldContainValues(this.actual, values, valuesNotFound));
        }
        return (MultimapAssert)this.myself;
    }

    public void isEmpty() {
        this.isNotNull();
        if (!((Multimap)this.actual).isEmpty()) {
            throw this.assertionError(ShouldBeEmpty.shouldBeEmpty((Object)this.actual));
        }
    }

    public void isNotEmpty() {
        this.isNotNull();
        if (((Multimap)this.actual).isEmpty()) {
            throw this.assertionError(ShouldNotBeEmpty.shouldNotBeEmpty());
        }
    }

    public MultimapAssert<K, V> hasSize(int expectedSize) {
        this.isNotNull();
        int sizeOfActual = ((Multimap)this.actual).size();
        if (sizeOfActual == expectedSize) {
            return this;
        }
        throw this.assertionError(ShouldHaveSize.shouldHaveSize((Object)this.actual, (int)sizeOfActual, (int)expectedSize));
    }

    public final MultimapAssert<K, V> hasSameEntriesAs(Multimap<? extends K, ? extends V> other) {
        this.isNotNull();
        ExceptionUtils.throwIllegalArgumentExceptionIfTrue(other == null, "The multimap to compare actual with should not be null", new Object[0]);
        Sets.SetView entriesNotExpectedInActual = Sets.difference((Set)Sets.newLinkedHashSet((Iterable)((Multimap)this.actual).entries()), (Set)Sets.newLinkedHashSet((Iterable)other.entries()));
        Sets.SetView entriesNotFoundInActual = Sets.difference((Set)Sets.newLinkedHashSet((Iterable)other.entries()), (Set)Sets.newLinkedHashSet((Iterable)((Multimap)this.actual).entries()));
        if (entriesNotFoundInActual.isEmpty() && entriesNotExpectedInActual.isEmpty()) {
            return (MultimapAssert)this.myself;
        }
        throw this.assertionError(ShouldContainOnly.shouldContainOnly((Object)this.actual, other, (Iterable)entriesNotFoundInActual, (Iterable)entriesNotExpectedInActual));
    }

    public final MultimapAssert<K, V> containsAllEntriesOf(Multimap<? extends K, ? extends V> other) {
        this.isNotNull();
        ExceptionUtils.throwIllegalArgumentExceptionIfTrue(other == null, "The multimap to compare actual with should not be null", new Object[0]);
        Sets.SetView entriesNotFoundInActual = Sets.difference((Set)Sets.newLinkedHashSet((Iterable)other.entries()), (Set)Sets.newLinkedHashSet((Iterable)((Multimap)this.actual).entries()));
        if (entriesNotFoundInActual.isEmpty()) {
            return (MultimapAssert)this.myself;
        }
        throw this.assertionError(ShouldContain.shouldContain((Object)this.actual, other, (Object)entriesNotFoundInActual));
    }

    public MultimapAssert<K, V> doesNotContainKey(K key) {
        return this.doesNotContainKeys(key);
    }

    public MultimapAssert<K, V> doesNotContainKeys(K ... keys) {
        this.isNotNull();
        this.assertDoesNotContainKeys(keys);
        return this;
    }

    private void assertDoesNotContainKeys(K[] keys) {
        Objects.requireNonNull(keys, "The array of keys to look for should not be null");
        Set<K> foundKeys = MultimapAssert.findKeys((Multimap)this.actual, keys);
        if (!foundKeys.isEmpty()) {
            throw this.assertionError(ShouldNotContainKeys.shouldNotContainKeys((Object)this.actual, foundKeys));
        }
    }

    private static <K> Set<K> findKeys(Multimap<K, ?> actual, K[] expectedKeys) {
        LinkedHashSet<K> foundKeys = new LinkedHashSet<K>();
        for (K expectedKey : expectedKeys) {
            if (!actual.containsKey(expectedKey)) continue;
            foundKeys.add(expectedKey);
        }
        return foundKeys;
    }
}

