/*
 * Decompiled with CFR 0.152.
 */
package org.assertj.assertions.generator.description.converter;

import com.google.common.base.Preconditions;
import com.google.common.reflect.TypeToken;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.util.List;
import java.util.Set;
import java.util.TreeSet;
import org.assertj.assertions.generator.GenerateAssertion;
import org.assertj.assertions.generator.description.ClassDescription;
import org.assertj.assertions.generator.description.FieldDescription;
import org.assertj.assertions.generator.description.GetterDescription;
import org.assertj.assertions.generator.description.converter.AnnotationConfiguration;
import org.assertj.assertions.generator.description.converter.ClassDescriptionConverter;
import org.assertj.assertions.generator.util.ClassUtil;

public class ClassToClassDescriptionConverter
implements ClassDescriptionConverter<TypeToken<?>> {
    private final AnnotationConfiguration annotationConfiguration;

    public ClassToClassDescriptionConverter() {
        this(new AnnotationConfiguration(GenerateAssertion.class));
    }

    public ClassToClassDescriptionConverter(AnnotationConfiguration annotationConfiguration) {
        this.annotationConfiguration = annotationConfiguration;
    }

    @Override
    public ClassDescription convertToClassDescription(TypeToken<?> type) {
        Preconditions.checkArgument((!type.getRawType().isLocalClass() ? 1 : 0) != 0, (String)"Can not support Local class %s", type);
        ClassDescription classDescription = new ClassDescription(type);
        classDescription.addGetterDescriptions(this.getterDescriptionsOf(type));
        classDescription.addFieldDescriptions(this.fieldDescriptionsOf(type));
        classDescription.addDeclaredGetterDescriptions(this.declaredGetterDescriptionsOf(type));
        classDescription.addDeclaredFieldDescriptions(this.declaredFieldDescriptionsOf(type));
        classDescription.setSuperType(type.getRawType().getSuperclass());
        return classDescription;
    }

    @Override
    public ClassDescription convertToClassDescription(Class<?> clazz) {
        Preconditions.checkArgument((!clazz.isLocalClass() ? 1 : 0) != 0, (String)"Can not support Local class %s", clazz);
        return this.convertToClassDescription(TypeToken.of(clazz));
    }

    private Set<GetterDescription> getterDescriptionsOf(TypeToken<?> type) {
        return this.doGetterDescriptionsOf(ClassUtil.getterMethodsOf(type, this.annotationConfiguration.includedAnnotations()), type);
    }

    private Set<GetterDescription> declaredGetterDescriptionsOf(TypeToken<?> type) {
        return this.doGetterDescriptionsOf(ClassUtil.declaredGetterMethodsOf(type, this.annotationConfiguration.includedAnnotations()), type);
    }

    private Set<GetterDescription> doGetterDescriptionsOf(Set<Method> getters, TypeToken<?> type) {
        TreeSet<GetterDescription> getterDescriptions = new TreeSet<GetterDescription>();
        for (Method getter : getters) {
            if (this.isGetDeclaringClassEnumGetter(getter, type.getRawType())) continue;
            String propertyName = ClassUtil.propertyNameOf(getter);
            getterDescriptions.add(new GetterDescription(propertyName, type, getter));
        }
        return getterDescriptions;
    }

    private Set<FieldDescription> declaredFieldDescriptionsOf(TypeToken<?> type) {
        return this.doFieldDescriptionsOf(type, ClassUtil.declaredFieldsOf(type));
    }

    private Set<FieldDescription> fieldDescriptionsOf(TypeToken<?> type) {
        return this.doFieldDescriptionsOf(type, ClassUtil.nonStaticFieldsOf(type));
    }

    private Set<FieldDescription> doFieldDescriptionsOf(TypeToken<?> type, List<Field> fields) {
        TreeSet<FieldDescription> fieldDescriptions = new TreeSet<FieldDescription>();
        for (Field field : fields) {
            fieldDescriptions.add(new FieldDescription(field, ClassUtil.visibilityOf(field), type));
        }
        return fieldDescriptions;
    }

    private boolean isGetDeclaringClassEnumGetter(Method getter, Class<?> clazz) {
        return clazz.isEnum() && getter.getName().equals("getDeclaringClass");
    }
}

