/*
 * Decompiled with CFR 0.152.
 */
package org.asciidoctor.arquillian;

import java.io.IOException;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import org.asciidoctor.Asciidoctor;
import org.asciidoctor.arquillian.AnnotationUtils;
import org.asciidoctor.arquillian.ScopedAsciidoctor;
import org.asciidoctor.arquillian.ScopedTemporaryFolder;
import org.asciidoctor.arquillian.SecurityActions;
import org.asciidoctor.arquillian.api.Shared;
import org.asciidoctor.arquillian.api.Unshared;
import org.asciidoctor.jruby.AsciidoctorJRuby;
import org.asciidoctor.junit.ClasspathResources;
import org.jboss.arquillian.core.api.InstanceProducer;
import org.jboss.arquillian.core.api.annotation.ApplicationScoped;
import org.jboss.arquillian.core.api.annotation.Inject;
import org.jboss.arquillian.core.api.annotation.Observes;
import org.jboss.arquillian.test.api.ArquillianResource;
import org.jboss.arquillian.test.spi.event.suite.After;
import org.jboss.arquillian.test.spi.event.suite.AfterClass;
import org.jboss.arquillian.test.spi.event.suite.Before;
import org.jboss.arquillian.test.spi.event.suite.BeforeClass;
import org.junit.rules.TemporaryFolder;

public class AsciidoctorTestObserver {
    @Inject
    @ApplicationScoped
    private InstanceProducer<ScopedAsciidoctor> scopedAsciidoctor;
    @Inject
    @ApplicationScoped
    private InstanceProducer<ScopedTemporaryFolder> scopedTemporaryFolder;
    @Inject
    @ApplicationScoped
    private InstanceProducer<ClasspathResources> classpathResourcesInstanceProducer;

    public void beforeTestClassCreateScopedResourceHolder(@Observes(precedence=100) BeforeClass beforeClass) {
        this.scopedAsciidoctor.set((Object)new ScopedAsciidoctor());
        this.scopedTemporaryFolder.set((Object)new ScopedTemporaryFolder());
    }

    public void beforeTestClassCreateSharedAsciidoctorInstance(@Observes(precedence=-100) BeforeClass beforeClass) {
        if (this.isSharedInstanceRequired(beforeClass.getTestClass().getJavaClass(), AsciidoctorJRuby.class)) {
            ((ScopedAsciidoctor)this.scopedAsciidoctor.get()).setSharedAsciidoctor((Asciidoctor)AsciidoctorJRuby.Factory.create());
        } else if (this.isSharedInstanceRequired(beforeClass.getTestClass().getJavaClass(), Asciidoctor.class)) {
            ((ScopedAsciidoctor)this.scopedAsciidoctor.get()).setSharedAsciidoctor(Asciidoctor.Factory.create());
        }
    }

    public void beforeTestClassCreateSharedTemporaryFolder(@Observes(precedence=-100) BeforeClass beforeClass) throws IOException {
        if (this.isSharedInstanceRequired(beforeClass.getTestClass().getJavaClass(), TemporaryFolder.class)) {
            TemporaryFolder temporaryFolder = new TemporaryFolder();
            temporaryFolder.create();
            ((ScopedTemporaryFolder)this.scopedTemporaryFolder.get()).setSharedTemporaryFolder(temporaryFolder);
        }
    }

    public void beforeTestClassCreateClasspathResources(@Observes BeforeClass beforeClass) {
        ClasspathResources classpathResources = new ClasspathResources(beforeClass.getTestClass().getJavaClass());
        this.classpathResourcesInstanceProducer.set((Object)classpathResources);
    }

    public void beforeTestCreateUnsharedAsciidoctorInstance(@Observes(precedence=5) Before before) {
        if (this.isUnsharedInstanceRequired(before.getTestClass().getJavaClass(), AsciidoctorJRuby.class) || this.isUnsharedInstanceRequired(before.getTestMethod(), Asciidoctor.class)) {
            ((ScopedAsciidoctor)this.scopedAsciidoctor.get()).setUnsharedAsciidoctor((Asciidoctor)AsciidoctorJRuby.Factory.create());
        } else if (this.isUnsharedInstanceRequired(before.getTestClass().getJavaClass(), Asciidoctor.class) || this.isUnsharedInstanceRequired(before.getTestMethod(), Asciidoctor.class)) {
            ((ScopedAsciidoctor)this.scopedAsciidoctor.get()).setUnsharedAsciidoctor(Asciidoctor.Factory.create());
        }
    }

    public void beforeTestCreateUnsharedTemporaryFolder(@Observes(precedence=5) Before before) throws IOException {
        if (this.isUnsharedInstanceRequired(before.getTestClass().getJavaClass(), TemporaryFolder.class) || this.isUnsharedInstanceRequired(before.getTestMethod(), TemporaryFolder.class)) {
            TemporaryFolder temporaryFolder = new TemporaryFolder();
            temporaryFolder.create();
            ((ScopedTemporaryFolder)this.scopedTemporaryFolder.get()).setUnsharedTemporaryFolder(temporaryFolder);
        }
    }

    public void afterTestShutdownUnsharedAsciidoctorInstance(@Observes After after) {
        Asciidoctor asciidoctor = ((ScopedAsciidoctor)this.scopedAsciidoctor.get()).getUnsharedAsciidoctor();
        if (asciidoctor != null) {
            asciidoctor.shutdown();
            ((ScopedAsciidoctor)this.scopedAsciidoctor.get()).setUnsharedAsciidoctor(null);
        }
    }

    public void afterTestShutdownUnsharedTemporaryFolderInstance(@Observes After after) {
        TemporaryFolder temporaryFolder = ((ScopedTemporaryFolder)this.scopedTemporaryFolder.get()).getUnsharedTemporaryFolder();
        if (temporaryFolder != null) {
            temporaryFolder.delete();
            ((ScopedTemporaryFolder)this.scopedTemporaryFolder.get()).setUnsharedTemporaryFolder(null);
        }
    }

    public void afterTestClassShutdownSharedAsciidoctorInstance(@Observes AfterClass afterClass) {
        Asciidoctor asciidoctor = ((ScopedAsciidoctor)this.scopedAsciidoctor.get()).getSharedAsciidoctor();
        if (asciidoctor != null) {
            asciidoctor.shutdown();
            ((ScopedAsciidoctor)this.scopedAsciidoctor.get()).setSharedAsciidoctor(null);
        }
    }

    public void afterTestClassShutdownSharedTemporaryFolderInstance(@Observes AfterClass afterClass) {
        TemporaryFolder temporaryFolder = ((ScopedTemporaryFolder)this.scopedTemporaryFolder.get()).getSharedTemporaryFolder();
        if (temporaryFolder != null) {
            temporaryFolder.delete();
            ((ScopedTemporaryFolder)this.scopedTemporaryFolder.get()).setSharedTemporaryFolder(null);
        }
    }

    private boolean isSharedInstanceRequired(Class<?> testClass, Class<?> resourceClass) {
        for (Field f : SecurityActions.getFieldsWithAnnotation(testClass, ArquillianResource.class)) {
            ArquillianResource arquillianResource = SecurityActions.getAnnotation(f, ArquillianResource.class);
            if (f.getType() != resourceClass || arquillianResource.value() != Shared.class) continue;
            return true;
        }
        return false;
    }

    private boolean isUnsharedInstanceRequired(Class<?> testClass, Class<?> resourceClass) {
        for (Field f : SecurityActions.getFieldsWithAnnotation(testClass, ArquillianResource.class)) {
            ArquillianResource arquillianResource = SecurityActions.getAnnotation(f, ArquillianResource.class);
            if (f.getType() != resourceClass || arquillianResource.value() != ArquillianResource.class && arquillianResource.value() != Unshared.class) continue;
            return true;
        }
        return false;
    }

    private boolean isSharedInstanceRequired(Method testMethod, Class<?> resourceClass) {
        for (int i = 0; i < testMethod.getParameterTypes().length; ++i) {
            ArquillianResource arquillianResource;
            if (testMethod.getParameterTypes()[i] != resourceClass || (arquillianResource = AnnotationUtils.filterAnnotation(testMethod.getParameterAnnotations()[i], ArquillianResource.class)) == null || arquillianResource.value() != Unshared.class) continue;
            return true;
        }
        return false;
    }

    private boolean isUnsharedInstanceRequired(Method testMethod, Class<?> resourceClass) {
        for (int i = 0; i < testMethod.getParameterTypes().length; ++i) {
            ArquillianResource arquillianResource;
            if (testMethod.getParameterTypes()[i] != resourceClass || (arquillianResource = AnnotationUtils.filterAnnotation(testMethod.getParameterAnnotations()[i], ArquillianResource.class)) == null || arquillianResource.value() != ArquillianResource.class && arquillianResource.value() != Unshared.class) continue;
            return true;
        }
        return false;
    }
}

