/*
 * Decompiled with CFR 0.152.
 */
package org.artifactory.util;

import java.io.File;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.regex.Pattern;
import org.apache.commons.lang.StringUtils;

public class PathUtils {
    private static final Pattern PATTERN_SLASHES = Pattern.compile("/+");

    public static boolean hasLength(String str) {
        return str != null && str.length() > 0;
    }

    public static boolean hasText(String str) {
        if (!PathUtils.hasLength(str)) {
            return false;
        }
        int strLen = str.length();
        int i = 0;
        while (i < strLen) {
            if (!Character.isWhitespace(str.charAt(i))) {
                return true;
            }
            ++i;
        }
        return false;
    }

    public static String trimWhitespace(String str) {
        if (!PathUtils.hasLength(str)) {
            return str;
        }
        StringBuffer buf = new StringBuffer(str);
        while (buf.length() > 0 && Character.isWhitespace(buf.charAt(0))) {
            buf.deleteCharAt(0);
        }
        while (buf.length() > 0 && Character.isWhitespace(buf.charAt(buf.length() - 1))) {
            buf.deleteCharAt(buf.length() - 1);
        }
        return buf.toString();
    }

    public static String getFileName(String path) {
        if (path == null) {
            return null;
        }
        File dummy = new File(path);
        return dummy.getName();
    }

    public static String getParent(String path) {
        if (path == null) {
            return null;
        }
        File dummy = new File(path);
        return PathUtils.formatPath(dummy.getParent());
    }

    public static String getExtension(String path) {
        if (path == null) {
            return null;
        }
        int dotPos = path.lastIndexOf(46);
        if (dotPos < 0) {
            return null;
        }
        return path.substring(dotPos + 1);
    }

    public static String stripExtension(String path) {
        String result = path;
        String extension = PathUtils.getExtension(path);
        if (extension != null) {
            result = path.substring(0, path.length() - extension.length() - 1);
        }
        return result;
    }

    public static String collectionToDelimitedString(Iterable<String> iterable) {
        return PathUtils.collectionToDelimitedString(iterable, ",");
    }

    public static String collectionToDelimitedString(Iterable<String> iterable, String delim) {
        if (iterable == null) {
            return "";
        }
        Iterator<String> it = iterable.iterator();
        if (it == null || !it.hasNext()) {
            return "";
        }
        StringBuilder sb = new StringBuilder();
        while (it.hasNext()) {
            String str;
            String next = it.next();
            String string = str = next != null ? next : null;
            if (str == null || (str = str.trim()).length() == 0) continue;
            sb.append(str);
            if (!it.hasNext()) continue;
            sb.append(delim);
        }
        return sb.toString();
    }

    public static List<String> includesExcludesPatternToStringList(String str) {
        return PathUtils.delimitedListToStringList(str, ",", "\r\n\f ");
    }

    public static List<String> delimitedListToStringList(String str, String delimiter) {
        return PathUtils.delimitedListToStringList(str, delimiter, "\r\n\f\t ");
    }

    public static List<String> delimitedListToStringList(String str, String delimiter, String charsToDelete) {
        ArrayList<String> result = new ArrayList<String>();
        if (str == null) {
            return result;
        }
        if (delimiter == null) {
            result.add(str);
            return result;
        }
        if ("".equals(delimiter)) {
            int i = 0;
            while (i < str.length()) {
                result.add(PathUtils.deleteAny(str.substring(i, i + 1), charsToDelete));
                ++i;
            }
        } else {
            int delPos;
            int pos = 0;
            while ((delPos = str.indexOf(delimiter, pos)) != -1) {
                result.add(PathUtils.deleteAny(str.substring(pos, delPos), charsToDelete));
                pos = delPos + delimiter.length();
            }
            if (str.length() > 0 && pos <= str.length()) {
                result.add(PathUtils.deleteAny(str.substring(pos), charsToDelete));
            }
        }
        return result;
    }

    public static String deleteAny(String inString, String charsToDelete) {
        if (!PathUtils.hasLength(inString) || !PathUtils.hasLength(charsToDelete)) {
            return inString;
        }
        StringBuffer out = new StringBuffer();
        int i = 0;
        while (i < inString.length()) {
            char c = inString.charAt(i);
            if (charsToDelete.indexOf(c) == -1) {
                out.append(c);
            }
            ++i;
        }
        return out.toString();
    }

    public static String formatRelativePath(String path) {
        CharSequence trimmed = PathUtils.trimSlashes(path = PathUtils.formatPath(path));
        return trimmed != null ? trimmed.toString() : null;
    }

    public static String formatPath(String path) {
        if (PathUtils.hasText(path)) {
            path = path.replace('\\', '/');
            return PathUtils.normalizeSlashes(path).toString();
        }
        return "";
    }

    public static CharSequence trimSlashes(CharSequence path) {
        if (path == null) {
            return null;
        }
        path = PathUtils.trimLeadingSlashChars(path);
        path = PathUtils.trimTrailingSlashesChars(path);
        return path;
    }

    public static String trimLeadingSlashes(CharSequence path) {
        CharSequence res = PathUtils.trimLeadingSlashChars(path);
        return res != null ? res.toString() : null;
    }

    public static CharSequence normalizeSlashes(CharSequence path) {
        if (path == null) {
            return null;
        }
        return PATTERN_SLASHES.matcher(path).replaceAll("/");
    }

    public static CharSequence trimLeadingSlashChars(CharSequence path) {
        if (path == null) {
            return null;
        }
        if (path.length() > 0 && path.charAt(0) == '/') {
            path = path.subSequence(1, path.length());
            return PathUtils.trimLeadingSlashChars(path);
        }
        return path;
    }

    public static String trimTrailingSlashes(CharSequence path) {
        CharSequence res = PathUtils.trimTrailingSlashesChars(path);
        return res != null ? res.toString() : null;
    }

    public static CharSequence trimTrailingSlashesChars(CharSequence path) {
        if (path == null) {
            return null;
        }
        if (path.length() > 0 && path.charAt(path.length() - 1) == '/') {
            path = path.subSequence(0, path.length() - 1);
            return PathUtils.trimTrailingSlashes(path);
        }
        return path;
    }

    public static String addTrailingSlash(String path) {
        if (path == null) {
            return null;
        }
        return (path = PathUtils.trimWhitespace(path)).endsWith("/") ? path : String.valueOf(path) + "/";
    }

    public static boolean safeStringEquals(String s1, String s2) {
        return s1 == s2 || s1 != null && s1.equals(s2);
    }

    public static String getRelativePath(String parentPath, String childPath) {
        childPath = childPath.substring(parentPath.length(), childPath.length());
        childPath = PathUtils.formatRelativePath(childPath);
        return childPath;
    }

    public static String injectString(String str, String toInject, int injectionIndex) {
        if (!PathUtils.hasText(str) || !PathUtils.hasText(toInject)) {
            return str;
        }
        return String.valueOf(str.substring(0, injectionIndex)) + toInject + str.substring(injectionIndex);
    }

    public static String[] getPathElements(String path) {
        if (path == null) {
            return new String[0];
        }
        if (path.startsWith("/")) {
            path = path.substring(1);
        }
        return path.split("/");
    }

    public static String getAncesstor(String path, int depth) {
        String[] elements = PathUtils.getPathElements(path);
        if (elements.length < depth) {
            throw new IllegalArgumentException("Ancesstor of level " + depth + " does not exist for " + path + ".");
        }
        StringBuilder sb = new StringBuilder();
        int i = 0;
        while (i < elements.length - depth) {
            String element = elements[i];
            if (sb.length() > 0) {
                sb.append('/');
            }
            sb.append(element);
            ++i;
        }
        if (path.startsWith("/")) {
            sb.insert(0, '/');
        }
        return sb.toString();
    }

    public static String getFirstPathElement(String path) {
        if (path == null) {
            return null;
        }
        String[] elements = PathUtils.getPathElements(path);
        if (elements.length > 0) {
            return elements[0];
        }
        return "";
    }

    public static String getLastPathElement(String path) {
        if (path == null) {
            return null;
        }
        String[] elements = PathUtils.getPathElements(path);
        if (elements.length > 0) {
            return elements[elements.length - 1];
        }
        return "";
    }

    public static String stripFirstPathElement(String path) {
        if (path == null) {
            return null;
        }
        int indexOfFirstSlash = (path = PathUtils.trimLeadingSlashes(path)).indexOf(47);
        if (indexOfFirstSlash < 0) {
            return "";
        }
        return path.substring(indexOfFirstSlash + 1);
    }

    public static boolean isDirectoryPath(String path) {
        return StringUtils.isEmpty((String)path) || path.matches(".*[/\\\\]$");
    }

    public static String[] splitZipResourcePathIfExist(String path, boolean recursive) {
        int zipResourceStart = path.indexOf(33);
        if (zipResourceStart > 0) {
            String zipResourcePath = path.substring(zipResourceStart + 1, path.length());
            if (zipResourcePath.startsWith("/")) {
                zipResourcePath = zipResourcePath.substring(1, zipResourcePath.length());
            }
            String[] subSplit = recursive ? PathUtils.splitZipResourcePathIfExist(zipResourcePath, true) : new String[]{zipResourcePath};
            String[] result = new String[subSplit.length + 1];
            result[0] = path.substring(0, zipResourceStart);
            System.arraycopy(subSplit, 0, result, 1, result.length - 1);
            return result;
        }
        return new String[]{path};
    }
}

