/*
 * Decompiled with CFR 0.152.
 */
package org.artifactory.repo;

import java.lang.reflect.Constructor;
import org.artifactory.repo.RepoPath;
import org.artifactory.util.PathUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class RepoPathFactory {
    private static final Logger log = LoggerFactory.getLogger(RepoPathFactory.class);
    private static Constructor<?> ctor;

    static {
        try {
            Class<?> clazz = RepoPathFactory.class.getClassLoader().loadClass("org.artifactory.model.common.RepoPathImpl");
            ctor = clazz.getConstructor(String.class, String.class);
        }
        catch (Exception e) {
            log.error("Error creating the repoPath factory.", (Throwable)e);
        }
    }

    public static RepoPath create(String repoKey, String path) {
        try {
            return (RepoPath)ctor.newInstance(repoKey, path);
        }
        catch (Exception e) {
            throw new RuntimeException("Could create repoPath.", e);
        }
    }

    public static RepoPath create(String rpp) {
        String path;
        String repoKey;
        if (rpp == null || rpp.length() == 0) {
            throw new IllegalArgumentException("Path cannot be empty.");
        }
        rpp = PathUtils.formatPath(rpp);
        int idx = (rpp = PathUtils.trimSlashes(rpp).toString()).indexOf(47);
        if (idx < 0) {
            repoKey = rpp;
            path = "";
        } else {
            repoKey = rpp.substring(0, idx);
            path = PathUtils.formatRelativePath(rpp.substring(idx + 1));
        }
        return RepoPathFactory.create(repoKey, path);
    }
}

