/*
 * Decompiled with CFR 0.152.
 */
package org.artifactory.checksum;

import com.thoughtworks.xstream.annotations.XStreamAlias;
import java.io.Serializable;
import java.util.EnumMap;
import java.util.HashSet;
import java.util.Set;
import org.artifactory.checksum.ChecksumInfo;
import org.artifactory.checksum.ChecksumType;

@XStreamAlias(value="checksumsInfo")
public class ChecksumsInfo
implements Serializable {
    private final EnumMap<ChecksumType, ChecksumInfo> checksums = new EnumMap(ChecksumType.class);

    public ChecksumsInfo() {
    }

    public ChecksumsInfo(ChecksumsInfo other) {
        if (!other.isEmpty()) {
            for (ChecksumInfo checksum : other.getChecksums()) {
                this.addChecksumInfo(checksum);
            }
        }
    }

    public boolean isEmpty() {
        return this.checksums.isEmpty();
    }

    public int size() {
        return this.checksums.size();
    }

    public String getSha1() {
        ChecksumInfo sha1 = this.getChecksumInfo(ChecksumType.sha1);
        return sha1 == null ? null : sha1.getActual();
    }

    public String getMd5() {
        ChecksumInfo md5 = this.getChecksumInfo(ChecksumType.md5);
        return md5 == null ? null : md5.getActual();
    }

    public void setChecksums(Set<ChecksumInfo> checksums) {
        if (checksums == null) {
            throw new IllegalArgumentException("Checksums cannot be null.");
        }
        this.checksums.clear();
        for (ChecksumInfo checksum : checksums) {
            this.addChecksumInfo(checksum);
        }
    }

    public Set<ChecksumInfo> getChecksums() {
        return new HashSet<ChecksumInfo>(this.checksums.values());
    }

    public ChecksumInfo getChecksumInfo(ChecksumType type) {
        return this.checksums.get((Object)type);
    }

    public void addChecksumInfo(ChecksumInfo checksumInfo) {
        if (checksumInfo == null) {
            throw new IllegalArgumentException("Nulls are not allowed");
        }
        this.checksums.put(checksumInfo.getType(), checksumInfo);
    }

    public void createTrustedChecksums() {
        ChecksumType[] types;
        ChecksumType[] checksumTypeArray = types = ChecksumType.values();
        int n = types.length;
        int n2 = 0;
        while (n2 < n) {
            ChecksumType type = checksumTypeArray[n2];
            this.addChecksumInfo(new ChecksumInfo(type, "NO_ORIG", null));
            ++n2;
        }
    }

    public boolean isIdentical(ChecksumsInfo info) {
        if (this.checksums == info.checksums) {
            return true;
        }
        if (this.checksums == null || info.checksums == null) {
            return false;
        }
        if (this.checksums.size() != info.checksums.size()) {
            return false;
        }
        for (ChecksumInfo other : this.checksums.values()) {
            ChecksumInfo mine;
            if (other.isIdentical(mine = info.getChecksumInfo(other.getType()))) continue;
            return false;
        }
        return true;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        ChecksumsInfo that = (ChecksumsInfo)o;
        return !(this.checksums != null ? !this.checksums.equals((Object)that.checksums) : that.checksums != null);
    }

    public int hashCode() {
        return this.checksums != null ? this.checksums.hashCode() : 0;
    }

    public String toString() {
        return "ChecksumsInfo" + "{checksums=" + this.checksums + '}';
    }
}

