/*
 * Decompiled with CFR 0.152.
 */
package org.artifactory.addon.plugin;

import com.google.common.collect.Maps;
import com.google.common.collect.Sets;
import java.io.Serializable;
import java.util.Collection;
import java.util.Map;
import java.util.Set;

public class PluginInfo
implements Serializable {
    private String name;
    private String version = "undefined";
    private String description;
    private Set<String> permittedUsers = Sets.newHashSet();
    private Set<String> permittedGroups = Sets.newHashSet();
    private Map params = Maps.newHashMap();
    private String httpMethod = "POST";

    public PluginInfo(String name, Map pluginClosureParams) {
        this.name = name;
        if (pluginClosureParams != null && !pluginClosureParams.isEmpty()) {
            if (pluginClosureParams.containsKey("version")) {
                this.version = pluginClosureParams.get("version").toString();
            }
            if (pluginClosureParams.containsKey("description")) {
                this.description = pluginClosureParams.get("description").toString();
            }
            if (pluginClosureParams.containsKey("httpMethod")) {
                this.httpMethod = pluginClosureParams.get("httpMethod").toString();
            }
            if (pluginClosureParams.containsKey("users")) {
                Object users = pluginClosureParams.get("users");
                if (users instanceof Collection) {
                    this.permittedUsers.addAll((Collection)users);
                } else {
                    this.permittedUsers.add(users.toString());
                }
            }
            if (pluginClosureParams.containsKey("groups")) {
                Object groups = pluginClosureParams.get("groups");
                if (groups instanceof Collection) {
                    this.permittedGroups.addAll((Collection)groups);
                } else {
                    this.permittedGroups.add(groups.toString());
                }
            }
            if (pluginClosureParams.containsKey("params")) {
                Object paramsFromClosureConfig = pluginClosureParams.get("params");
                this.params.putAll((Map)paramsFromClosureConfig);
            }
        }
    }

    public String getHttpMethod() {
        return this.httpMethod;
    }

    public String getName() {
        return this.name;
    }

    public String getVersion() {
        return this.version;
    }

    public String getDescription() {
        return this.description;
    }

    public boolean isUserPermitted(String user) {
        return this.permittedUsers.contains(user);
    }

    public boolean isGroupPermitted(String group) {
        return this.permittedGroups.contains(group);
    }

    public Map getParams() {
        return this.params;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof PluginInfo)) {
            return false;
        }
        PluginInfo that = (PluginInfo)o;
        if (this.description != null ? !this.description.equals(that.description) : that.description != null) {
            return false;
        }
        if (this.httpMethod != null ? !this.httpMethod.equals(that.httpMethod) : that.httpMethod != null) {
            return false;
        }
        if (this.name != null ? !this.name.equals(that.name) : that.name != null) {
            return false;
        }
        if (this.params != null ? !this.params.equals(that.params) : that.params != null) {
            return false;
        }
        if (this.permittedGroups != null ? !this.permittedGroups.equals(that.permittedGroups) : that.permittedGroups != null) {
            return false;
        }
        if (this.permittedUsers != null ? !this.permittedUsers.equals(that.permittedUsers) : that.permittedUsers != null) {
            return false;
        }
        return !(this.version != null ? !this.version.equals(that.version) : that.version != null);
    }

    public int hashCode() {
        int result = this.name != null ? this.name.hashCode() : 0;
        result = 31 * result + (this.version != null ? this.version.hashCode() : 0);
        result = 31 * result + (this.description != null ? this.description.hashCode() : 0);
        result = 31 * result + (this.httpMethod != null ? this.httpMethod.hashCode() : 0);
        result = 31 * result + (this.permittedUsers != null ? this.permittedUsers.hashCode() : 0);
        result = 31 * result + (this.permittedGroups != null ? this.permittedGroups.hashCode() : 0);
        result = 31 * result + (this.params != null ? this.params.hashCode() : 0);
        return result;
    }
}

