/*
 * Decompiled with CFR 0.152.
 */
package org.artifactory.ui.rest.service.state;

import com.fasterxml.jackson.annotation.JsonIgnore;
import java.util.Date;
import java.util.List;
import lombok.Generated;
import org.apache.commons.lang.StringUtils;
import org.artifactory.ui.rest.service.state.FooterLink;
import org.jfrog.storage.binstore.utils.Checksum;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class FooterMessage {
    private static final Logger log = LoggerFactory.getLogger(FooterMessage.class);
    private final String title;
    private final String message;
    private final List<FooterLink> urls;
    private final String type;
    private final String visibility;
    private final String dismissCode;
    private Long showFrom;
    private Long showUntil;

    public FooterMessage() {
        this.message = null;
        this.title = null;
        this.urls = null;
        this.type = null;
        this.visibility = null;
        this.dismissCode = null;
        this.showFrom = null;
        this.showUntil = null;
    }

    private FooterMessage(String message, List<FooterLink> urls, FooterMessageType type, FooterMessageVisibility visibility) {
        this.title = null;
        this.message = message;
        this.urls = urls;
        this.type = type.name();
        this.visibility = visibility.name();
        this.dismissCode = null;
        this.showFrom = null;
        this.showUntil = null;
    }

    private FooterMessage(String title, String message, List<FooterLink> urls, FooterMessageType type, FooterMessageVisibility visibility, boolean dismissible) {
        this.title = title;
        this.message = message;
        this.urls = urls;
        this.type = type.name();
        this.visibility = visibility.name();
        this.dismissCode = this.getDismissCode(message, dismissible);
        this.showFrom = null;
        this.showUntil = null;
    }

    public FooterMessage(String title, String message, List<FooterLink> urls, String type, String visibility, boolean dismissible, Long showFrom, Long showUntil) {
        this.title = title;
        this.message = message;
        this.urls = urls;
        this.type = type;
        this.visibility = visibility;
        this.dismissCode = this.getDismissCode(message, dismissible);
        this.showFrom = showFrom;
        this.showUntil = showUntil;
    }

    public String getTitle() {
        return this.title;
    }

    public String getMessage() {
        return this.message;
    }

    public List<FooterLink> getUrls() {
        return this.urls;
    }

    public String getType() {
        return this.type;
    }

    public String getVisibility() {
        return this.visibility;
    }

    public String getDismissCode() {
        return this.dismissCode;
    }

    public Long getShowFrom() {
        return this.showFrom;
    }

    public Long getShowUntil() {
        return this.showUntil;
    }

    @JsonIgnore
    public boolean shouldShowMessage() {
        Date now = new Date();
        if (this.showFrom != null && !new Date(this.showFrom).before(now)) {
            log.debug("show from date '{}' for custom message not yet reached, now is: '{}'", (Object)this.showFrom, (Object)now);
            return false;
        }
        if (this.showUntil != null && !new Date(this.showUntil).after(now)) {
            log.debug("show until date '{}' for custom message has passed, now is: '{}'", (Object)this.showUntil, (Object)now);
            return false;
        }
        return true;
    }

    public static FooterMessage createWarning(String message, List<FooterLink> urls, FooterMessageVisibility visibility) {
        return new FooterMessage(message, urls, FooterMessageType.warning, visibility);
    }

    public static FooterMessage createInfo(String message, List<FooterLink> urls, FooterMessageVisibility visibility) {
        return new FooterMessage(message, urls, FooterMessageType.info, visibility);
    }

    public static FooterMessage createDismissibleInfo(String message, List<FooterLink> urls, FooterMessageVisibility visibility) {
        return new FooterMessage(null, message, urls, FooterMessageType.info, visibility, true);
    }

    public static FooterMessage createDismissibleWarning(String message, List<FooterLink> urls, FooterMessageVisibility visibility) {
        return new FooterMessage(null, message, urls, FooterMessageType.warning, visibility, true);
    }

    public static FooterMessage createError(String message, List<FooterLink> urls, FooterMessageVisibility visibility) {
        return new FooterMessage(message, urls, FooterMessageType.error, visibility);
    }

    public static FooterMessage createDismissibleError(String title, String message, List<FooterLink> urls, FooterMessageVisibility visibility) {
        return new FooterMessage(title, message, urls, FooterMessageType.error, visibility, true);
    }

    private String getDismissCode(String msg, boolean dismissible) {
        if (dismissible && StringUtils.isNotBlank((String)msg)) {
            try {
                Checksum msgMd5 = Checksum.md5();
                byte[] msgBytes = msg.getBytes();
                msgMd5.update(msgBytes, 0, msg.length());
                msgMd5.calc();
                return msgMd5.getChecksum();
            }
            catch (Exception e) {
                log.debug("Error calculating dismiss code for message '" + msg + "' --> ", (Throwable)e);
            }
        }
        return null;
    }

    @Generated
    public static FooterMessageBuilder builder() {
        return new FooterMessageBuilder();
    }

    @Generated
    public static class FooterMessageBuilder {
        @Generated
        private String title;
        @Generated
        private String message;
        @Generated
        private List<FooterLink> urls;
        @Generated
        private String type;
        @Generated
        private String visibility;
        @Generated
        private boolean dismissible;
        @Generated
        private Long showFrom;
        @Generated
        private Long showUntil;

        @Generated
        FooterMessageBuilder() {
        }

        @Generated
        public FooterMessageBuilder title(String title) {
            this.title = title;
            return this;
        }

        @Generated
        public FooterMessageBuilder message(String message) {
            this.message = message;
            return this;
        }

        @Generated
        public FooterMessageBuilder urls(List<FooterLink> urls) {
            this.urls = urls;
            return this;
        }

        @Generated
        public FooterMessageBuilder type(String type) {
            this.type = type;
            return this;
        }

        @Generated
        public FooterMessageBuilder visibility(String visibility) {
            this.visibility = visibility;
            return this;
        }

        @Generated
        public FooterMessageBuilder dismissible(boolean dismissible) {
            this.dismissible = dismissible;
            return this;
        }

        @Generated
        public FooterMessageBuilder showFrom(Long showFrom) {
            this.showFrom = showFrom;
            return this;
        }

        @Generated
        public FooterMessageBuilder showUntil(Long showUntil) {
            this.showUntil = showUntil;
            return this;
        }

        @Generated
        public FooterMessage build() {
            return new FooterMessage(this.title, this.message, this.urls, this.type, this.visibility, this.dismissible, this.showFrom, this.showUntil);
        }

        @Generated
        public String toString() {
            return "FooterMessage.FooterMessageBuilder(title=" + this.title + ", message=" + this.message + ", urls=" + this.urls + ", type=" + this.type + ", visibility=" + this.visibility + ", dismissible=" + this.dismissible + ", showFrom=" + this.showFrom + ", showUntil=" + this.showUntil + ")";
        }
    }

    public static enum FooterMessageVisibility {
        admin,
        user,
        all;


        public boolean isVisible(boolean adminPermission, boolean userPermission) {
            if (adminPermission) {
                return true;
            }
            if (userPermission) {
                return this == user || this == all;
            }
            return this == all;
        }

        public static boolean isVisible(String visibilityName, boolean admin, boolean notAnonymous) {
            try {
                FooterMessageVisibility visibility = FooterMessageVisibility.valueOf(visibilityName);
                return visibility.isVisible(admin, notAnonymous);
            }
            catch (Exception e) {
                return false;
            }
        }
    }

    static enum FooterMessageType {
        info,
        warning,
        error;

    }
}

