/*
 * Decompiled with CFR 0.152.
 */
package org.artifactory.request;

import com.google.common.collect.Multimap;
import com.google.common.collect.TreeMultimap;
import java.util.Arrays;
import java.util.Collection;
import java.util.Comparator;
import java.util.Enumeration;
import java.util.Map;
import java.util.stream.Stream;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import org.apache.commons.collections.iterators.IteratorEnumeration;
import org.artifactory.request.HttpHeadersContainter;
import org.jfrog.common.StreamSupportUtils;

public class HeadersMultiMap
implements HttpHeadersContainter {
    @Nonnull
    private Multimap<String, String> headers = TreeMultimap.create((Comparator)String.CASE_INSENSITIVE_ORDER, Comparator.reverseOrder());

    public HeadersMultiMap addAll(@Nonnull Stream<Map.Entry<String, String>> stream) {
        stream.forEach(it -> this.addHeader((String)it.getKey(), (String)it.getValue()));
        return this;
    }

    public HeadersMultiMap addAll(@Nonnull String key, @Nullable Enumeration<String> values) {
        if (values != null) {
            StreamSupportUtils.enumerationToStream(values).forEach(value -> this.addHeader(key, (String)value));
        }
        return this;
    }

    public Collection<Map.Entry<String, String>> entries() {
        return this.headers.entries();
    }

    public boolean contains(String key) {
        return this.headers.containsKey((Object)key);
    }

    public Multimap<String, String> getMultiHeaders() {
        return this.headers;
    }

    public void setHeader(@Nonnull String key, String value) {
        this.headers.removeAll((Object)key);
        if (value != null) {
            this.headers.put((Object)key, (Object)value);
        }
    }

    public void addHeader(@Nonnull String key, @Nullable String value) {
        if (value == null) {
            this.headers.removeAll((Object)key);
        } else {
            this.headers.put((Object)key, (Object)value);
        }
    }

    public HeadersMultiMap updateHeaders(@Nonnull Map<String, String> headers) {
        headers.forEach(this::setHeader);
        return this;
    }

    public Enumeration<String> getHeadersKeys() {
        return new IteratorEnumeration(this.headers.keySet().iterator());
    }

    public Enumeration<String> getHeaderValues(@Nonnull String headerName) {
        return new IteratorEnumeration(this.headers.get((Object)headerName).iterator());
    }

    public Stream<String> getAcceptHeadersMediaTypeWithoutOptions() {
        String key = "Accept";
        Enumeration<String> headerValues = this.getHeaderValues(key);
        return HeadersMultiMap.extractMediaTypeStringFromValues(headerValues);
    }

    public static Stream<String> extractMediaTypeStringFromValues(Enumeration<String> headerValues) {
        return StreamSupportUtils.enumerationToStream(headerValues).flatMap(it -> Arrays.stream(it.split(",")).map(mimeType -> mimeType.replaceFirst(";(?:.*)", "")).map(String::trim).map(String::toLowerCase));
    }

    public String toString() {
        return "HeadersMultiMap{headers=" + this.headers + "}";
    }
}

