/*
 * Decompiled with CFR 0.152.
 */
package org.artifactory.log.logback;

import com.jfrog.sysconf.SysLayout;
import java.io.File;
import java.util.Arrays;
import org.apache.commons.lang.StringUtils;
import org.artifactory.common.property.ArtifactorySystemProperties;
import org.jfrog.common.logging.logback.LogbackContextConfigurator;
import org.jfrog.common.logging.logback.servlet.LoggerConfigInfo;

public class ArtifactoryLoggerConfig
extends LoggerConfigInfo {
    public static final String LOG_DIR_PROP = "log.dir";
    private static final String LOG_DIR_ARCHIVED_PROP = "log.dir.archived";
    private final File logDir;

    public ArtifactoryLoggerConfig(String contextId, File logDir, File logbackConfigFile) {
        super(contextId, logbackConfigFile);
        this.logDir = logDir;
    }

    protected void configure(LogbackContextConfigurator configurator) {
        super.configure(configurator);
        configurator.property("artifactory.contextId", this.normalizedContextId()).property(LOG_DIR_PROP, this.logDir.getAbsolutePath()).property(LOG_DIR_ARCHIVED_PROP, new File(this.logDir.getAbsolutePath(), "archived").getAbsolutePath());
        String customProps = this.getTestEnvCustomProp();
        if (org.apache.commons.lang3.StringUtils.isNotBlank((CharSequence)customProps)) {
            String[] customParams = customProps.split(",");
            Arrays.stream(customParams).forEach(p -> configurator.property(p.split("::")[0], p.split("::")[1]));
        }
    }

    private String normalizedContextId() {
        Object contextId = StringUtils.trimToEmpty((String)this.getContextId());
        contextId = "artifactory".equalsIgnoreCase((String)contextId) ? "" : (String)contextId + " ";
        return StringUtils.isBlank((String)contextId) ? "" : ((String)contextId).toLowerCase();
    }

    private String getTestEnvCustomProp() {
        File homeDir = this.logDir.getParentFile().getParentFile();
        if (homeDir == null || !homeDir.exists()) {
            return "";
        }
        SysLayout layout = new SysLayout(homeDir, "artifactory");
        File systemProps = new File(layout.getServiceEtc(), "artifactory.system.properties");
        if (!systemProps.exists()) {
            return "";
        }
        try {
            ArtifactorySystemProperties properties = new ArtifactorySystemProperties();
            properties.loadArtifactorySystemProperties(systemProps, null);
            return properties.getProperty("artifactory.test.logback.custom", "");
        }
        catch (Exception exception) {
            return "";
        }
    }
}

