/*
 * Decompiled with CFR 0.152.
 */
package org.artifactory.aql.util;

import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.List;
import org.apache.commons.lang.StringUtils;
import org.artifactory.repo.InternalRepoPathFactory;
import org.artifactory.repo.RepoPath;
import org.jfrog.client.util.PathUtils;

public class AqlSearchablePath {
    private static final String FORWARD_SLASH = "/";
    private String repo;
    private String path;
    private String fileName;

    public AqlSearchablePath(String repo, String path, String fileName) {
        this.repo = repo;
        this.path = path;
        this.fileName = fileName;
    }

    public AqlSearchablePath(String fullPath) {
        this.repo = PathUtils.getFirstPathElement((String)fullPath);
        this.path = PathUtils.getParent((String)PathUtils.stripFirstPathElement((String)fullPath));
        this.fileName = PathUtils.getFileName((String)fullPath);
    }

    public AqlSearchablePath(RepoPath repoPath) {
        this.repo = repoPath.getRepoKey();
        try {
            this.path = repoPath.getParent().getPath();
        }
        catch (NullPointerException npe) {
            throw new IllegalArgumentException("Aql searchable path must be a full path to file (or *.*)");
        }
        if (StringUtils.isBlank((String)this.path)) {
            this.path = ".";
        }
        this.fileName = repoPath.getName();
    }

    public static List<AqlSearchablePath> fullPathToSearchablePathList(List<String> fullPaths) {
        ArrayList outList = Lists.newArrayList();
        for (String fullPath : fullPaths) {
            outList.add(new AqlSearchablePath(fullPath));
        }
        return outList;
    }

    public static List<AqlSearchablePath> relativePathToSearchablePathList(List<String> relativePaths, RepoPath originPath) {
        ArrayList outList = Lists.newArrayList();
        for (String relPath : relativePaths) {
            String fullPath = relPath.startsWith(FORWARD_SLASH) ? originPath.getRepoKey() + relPath : PathUtils.trimTrailingSlashes((CharSequence)originPath.toPath()) + FORWARD_SLASH + relPath;
            outList.add(new AqlSearchablePath(fullPath));
        }
        return outList;
    }

    public String getRepo() {
        return this.repo;
    }

    public void setRepo(String repo) {
        this.repo = repo;
    }

    public String getPath() {
        return this.path;
    }

    public void setPath(String path) {
        this.path = path;
    }

    public String getFileName() {
        return this.fileName;
    }

    public void setFileName(String fileName) {
        this.fileName = fileName;
    }

    public String toFullPath() {
        return this.repo + FORWARD_SLASH + this.path + FORWARD_SLASH + this.fileName;
    }

    public RepoPath toRepoPath() {
        return InternalRepoPathFactory.create((String)this.repo, (String)(this.path + FORWARD_SLASH + this.fileName));
    }
}

