/*
 * Decompiled with CFR 0.152.
 */
package org.artifactory.aql.model;

import org.artifactory.aql.AqlException;
import org.artifactory.aql.AqlParserException;
import org.artifactory.aql.model.AqlItemTypeEnum;
import org.artifactory.aql.model.AqlVariable;
import org.artifactory.aql.model.AqlVariableTypeEnum;
import org.joda.time.format.ISODateTimeFormat;

public class AqlValue
implements AqlVariable {
    private AqlVariableTypeEnum valueType;
    private String value;

    public AqlValue(AqlVariableTypeEnum valueType, String value) {
        this.valueType = valueType;
        this.value = value;
    }

    public Object toObject() throws AqlException {
        Object result = this.value;
        if (this.value == null) {
            return null;
        }
        if (AqlVariableTypeEnum.string == this.valueType) {
            result = this.value;
        }
        if (AqlVariableTypeEnum.date == this.valueType) {
            try {
                result = Long.parseLong(this.value);
            }
            catch (Exception e1) {
                try {
                    result = ISODateTimeFormat.dateOptionalTimeParser().parseMillis(this.value);
                }
                catch (Exception e2) {
                    throw new AqlParserException(String.format("Invalid Date format: %s, AQL expect ISODateTimeFormat or long number", this.value), e2);
                }
            }
        }
        if (AqlVariableTypeEnum.longInt == this.valueType) {
            try {
                result = Long.valueOf(this.value);
            }
            catch (NumberFormatException e) {
                throw new AqlException("AQL Expect long value but found:" + this.value.toString() + "\n");
            }
        }
        if (AqlVariableTypeEnum.itemType == this.valueType) {
            AqlItemTypeEnum aqlItemTypeEnum = AqlItemTypeEnum.fromSignature(this.value);
            if (aqlItemTypeEnum != null) {
                result = aqlItemTypeEnum.type;
            } else {
                throw new AqlException(String.format("Invalid file type: %s, valid types are : %s, %s, %s", this.value, AqlItemTypeEnum.file.signature, AqlItemTypeEnum.folder.signature, AqlItemTypeEnum.any.signature));
            }
        }
        if (AqlVariableTypeEnum.integer == this.valueType) {
            try {
                result = Integer.valueOf(this.value);
            }
            catch (NumberFormatException e) {
                throw new AqlException("AQL Expect integer value but found:" + this.value.toString() + "\n");
            }
        }
        return result;
    }
}

