/*
 * Decompiled with CFR 0.152.
 */
package org.artifactory.aql.model;

import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.artifactory.aql.model.AqlDomainEnum;
import org.artifactory.aql.model.AqlFieldEnum;
import org.artifactory.aql.model.AqlFieldEnumSwitch;

public enum AqlLogicalFieldEnum implements AqlFieldEnum
{
    itemVirtualRepos("virtual_repos", AqlDomainEnum.items);

    private final String signature;
    private final AqlDomainEnum domain;
    private static final AqlLogicalFieldEnum[] EMPTY_ARRAY;
    private static final Map<AqlDomainEnum, AqlLogicalFieldEnum[]> FIELDS_BY_DOMAIN;

    private AqlLogicalFieldEnum(String signature, AqlDomainEnum domain) {
        this.signature = signature;
        this.domain = domain;
    }

    @Override
    public String getSignature() {
        return this.signature;
    }

    @Override
    public AqlDomainEnum getDomain() {
        return this.domain;
    }

    @Override
    public String getName() {
        return this.name();
    }

    @Override
    public boolean isId() {
        return false;
    }

    @Override
    public <T> T doSwitch(AqlFieldEnumSwitch<T> fieldEnumSwitch) {
        return fieldEnumSwitch.caseOf(this);
    }

    static AqlLogicalFieldEnum[] getFieldsByDomain(AqlDomainEnum domain) {
        AqlLogicalFieldEnum[] fields = FIELDS_BY_DOMAIN.get((Object)domain);
        if (fields == null) {
            return EMPTY_ARRAY;
        }
        return fields;
    }

    static {
        EMPTY_ARRAY = new AqlLogicalFieldEnum[0];
        HashMap map = Maps.newHashMap();
        for (AqlLogicalFieldEnum field : AqlLogicalFieldEnum.values()) {
            List fields = (List)map.get((Object)field.domain);
            if (fields == null) {
                fields = Lists.newArrayList();
                map.put(field.domain, fields);
            }
            fields.add(field);
        }
        HashMap mapOfArrays = Maps.newHashMap();
        for (Map.Entry entry : map.entrySet()) {
            List fields = (List)entry.getValue();
            mapOfArrays.put((AqlDomainEnum)((Object)entry.getKey()), fields.toArray(new AqlLogicalFieldEnum[fields.size()]));
        }
        FIELDS_BY_DOMAIN = Collections.unmodifiableMap(mapOfArrays);
    }
}

