/*
 * Decompiled with CFR 0.152.
 */
package org.artifactory.api.storage;

public class StorageQuotaInfo {
    private final int diskSpaceLimitPercentage;
    private final int diskSpaceWarningPercentage;
    private double dataUsagePercentage;

    public StorageQuotaInfo(long totalSpace, long usedSpace, int diskSpaceLimitPercentage, int diskSpaceWarningPercentage) {
        this.diskSpaceLimitPercentage = diskSpaceLimitPercentage;
        this.diskSpaceWarningPercentage = diskSpaceWarningPercentage;
        this.dataUsagePercentage = (double)usedSpace / (double)totalSpace * 100.0;
    }

    public boolean isLimitReached() {
        return this.dataUsagePercentage >= (double)this.diskSpaceLimitPercentage;
    }

    public boolean isWarningLimitReached() {
        return this.dataUsagePercentage >= (double)this.diskSpaceWarningPercentage;
    }

    public int getDiskSpaceLimitPercentage() {
        return this.diskSpaceLimitPercentage;
    }

    public int getDiskSpaceWarningPercentage() {
        return this.diskSpaceWarningPercentage;
    }

    public String getErrorMessage() {
        return String.format("%s%% Storage Space Reached: Your maximum storage limit has been reached. New artifact deployments are blocked until more disk space is added.", this.getDiskSpaceLimitPercentage());
    }

    public String getWarningMessage() {
        return String.format("%s%% storage space reached. Your maximum limit is %s%%. It is recommended to add disk space.", this.getDiskSpaceWarningPercentage(), this.getDiskSpaceLimitPercentage());
    }
}

