/*
 * Decompiled with CFR 0.152.
 */
package org.artifactory.api.security;

import java.util.List;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import org.artifactory.api.security.PermissionHeuristicScore;
import org.artifactory.repo.RepoPath;
import org.artifactory.security.Acl;
import org.artifactory.security.ArtifactoryPermission;
import org.artifactory.security.GroupInfo;
import org.artifactory.security.PermissionTarget;
import org.artifactory.security.RepoPermissionTarget;
import org.artifactory.security.UserInfo;

public interface AuthorizationService {
    public static final String ROLE_USER = "user";
    public static final String ROLE_ADMIN = "admin";

    public boolean isUpdatableProfile();

    public boolean isTransientUser();

    public String getAuthenticatedRealm();

    public boolean isAnonAccessEnabled();

    public boolean canRead(RepoPath var1);

    public boolean canAnnotate(RepoPath var1);

    public boolean canDelete(RepoPath var1);

    public boolean canDeploy(RepoPath var1);

    public boolean canDeployToLocalRepository();

    public boolean canManage(RepoPath var1);

    public boolean hasRepoPermission(ArtifactoryPermission var1);

    public boolean hasBuildPermission(ArtifactoryPermission var1);

    public boolean hasReleaseBundlePermission(ArtifactoryPermission var1);

    public boolean hasPermission(ArtifactoryPermission var1);

    public boolean hasPermissionOnAcl(Acl<? extends PermissionTarget> var1, ArtifactoryPermission var2);

    public boolean hasBuildBasicReadPermission();

    public boolean hasBasicReadPermissionForAllBuilds();

    public boolean hasAnyPermission(GroupInfo var1, ArtifactoryPermission var2);

    public List<RepoPermissionTarget> getRepoPermissionTargets(UserInfo var1, ArtifactoryPermission var2);

    public boolean canRead(UserInfo var1, RepoPath var2);

    public boolean canAnnotate(UserInfo var1, RepoPath var2);

    public boolean canDelete(UserInfo var1, RepoPath var2);

    public boolean canDeploy(UserInfo var1, RepoPath var2);

    public boolean canManage(UserInfo var1, RepoPath var2);

    public boolean canRead(GroupInfo var1, RepoPath var2);

    public boolean canAnnotate(GroupInfo var1, RepoPath var2);

    public boolean canDelete(GroupInfo var1, RepoPath var2);

    public boolean canDeploy(GroupInfo var1, RepoPath var2);

    public boolean canManage(GroupInfo var1, RepoPath var2);

    public boolean isAdmin();

    public boolean isAnonymous();

    public boolean requireProfileUnlock(@Nullable String var1);

    public boolean requireProfilePassword();

    @Nonnull
    public String currentUsername();

    public boolean isAuthenticated();

    public boolean userHasPermissionsOnRepositoryRoot(String var1);

    public boolean isDisableInternalPassword();

    public String currentUserEncryptedPassword();

    public String currentUserEncryptedPasswordOrApiKey();

    public boolean isApiKeyAuthentication();

    public PermissionHeuristicScore getStrongestReadPermissionTarget(String var1);

    public boolean isBuildBasicRead(String var1);

    public boolean isBuildBasicRead(String var1, String var2, String var3);

    public boolean canReadBuild(String var1);

    public boolean canReadBuild(String var1, String var2);

    public boolean canReadBuild(String var1, String var2, String var3);

    public boolean canUploadBuild(String var1, String var2);

    public boolean canUploadBuild(String var1, String var2, String var3);

    public boolean canDeleteBuild(String var1);

    public boolean canDeleteBuild(String var1, String var2, String var3);

    public boolean canManageBuild(String var1, String var2, String var3);

    public boolean isProjectAdmin(String var1);

    public boolean isProjectAdmin(RepoPath var1);

    public boolean isAnyProjectAdmin();
}

