/*
 * Decompiled with CFR 0.152.
 */
package org.artifactory.api.security;

import com.google.common.collect.Multimap;
import java.util.List;
import java.util.Map;
import org.artifactory.sapi.common.Lock;
import org.artifactory.security.AceInfo;
import org.artifactory.security.Acl;
import org.artifactory.security.ArtifactoryPermission;
import org.artifactory.security.ArtifactoryResourceType;
import org.artifactory.security.BuildAcl;
import org.artifactory.security.GroupInfo;
import org.artifactory.security.MutableRepoAcl;
import org.artifactory.security.PermissionTarget;
import org.artifactory.security.PermissionTargetAcls;
import org.artifactory.security.ReleaseBundleAcl;
import org.artifactory.security.RepoAcl;
import org.artifactory.security.RepoPermissionTarget;
import org.artifactory.security.UserInfo;

public interface AclService {
    public List<RepoPermissionTarget> getRepoPermissionTargets(ArtifactoryPermission var1);

    public List<RepoAcl> getAllRepoAcls(ArtifactoryPermission var1);

    public List<BuildAcl> getAllBuildAcls(ArtifactoryPermission var1);

    public List<ReleaseBundleAcl> getAllReleaseBundleAcls(ArtifactoryPermission var1);

    public List<RepoAcl> getAllRepoAcls();

    public List<BuildAcl> getAllBuildAcls();

    public List<ReleaseBundleAcl> getAllReleaseBundleAcls(boolean var1);

    public List<Acl<? extends PermissionTarget>> getAllAcls();

    public boolean canManage(PermissionTarget var1);

    public boolean canManage(Acl<? extends PermissionTarget> var1);

    public boolean canRead(UserInfo var1, PermissionTarget var2);

    public boolean canAnnotate(UserInfo var1, PermissionTarget var2);

    public boolean canDeploy(UserInfo var1, PermissionTarget var2);

    public boolean canDelete(UserInfo var1, PermissionTarget var2);

    public boolean canManage(UserInfo var1, PermissionTarget var2);

    @Lock
    public void createAcl(Acl var1);

    @Lock
    public void deleteAcl(Acl var1);

    public void updateAcl(Acl var1);

    public void updateAcl(Acl var1, boolean var2);

    public RepoAcl getRepoAcl(String var1);

    public BuildAcl getBuildAcl(String var1);

    public ReleaseBundleAcl getReleaseBundleAcl(String var1);

    public ReleaseBundleAcl getReleaseBundleAclByLicense(String var1);

    public List<String> convertCachedRepoKeysToRemote(List<String> var1);

    public RepoAcl convertNewAclCachedRepoKeysToRemote(MutableRepoAcl var1);

    public Map<PermissionTarget, AceInfo> getUserPermissionByPrincipal(String var1, ArtifactoryResourceType var2);

    public Multimap<PermissionTarget, AceInfo> getUserPermissionAndItsGroups(String var1, ArtifactoryResourceType var2);

    public Multimap<PermissionTarget, AceInfo> getGroupsPermissions(List<String> var1, ArtifactoryResourceType var2);

    public Map<PermissionTarget, AceInfo> getUserPermissions(String var1, ArtifactoryResourceType var2);

    public Map<Character, List<PermissionTargetAcls>> getAllAclsMappedByPermissionTargetFirstChar(boolean var1);

    @Lock
    public void createDefaultSecurityEntities(UserInfo var1, GroupInfo var2, String var3);
}

