/*
 * Decompiled with CFR 0.152.
 */
package org.artifactory.api.search.gavc;

import org.apache.commons.lang.StringUtils;
import org.artifactory.api.module.ModuleInfo;
import org.artifactory.api.search.artifact.ArtifactSearchResult;
import org.artifactory.fs.ItemInfo;

public class GavcSearchResult
extends ArtifactSearchResult {
    private ModuleInfo moduleInfo;

    public GavcSearchResult(ItemInfo itemInfo, ModuleInfo moduleInfo) {
        super(itemInfo);
        this.moduleInfo = moduleInfo;
    }

    public String getGroupId() {
        return this.moduleInfo.getOrganization();
    }

    public String getArtifactId() {
        return this.moduleInfo.getModule();
    }

    public String getVersion() {
        StringBuilder revisionBuilder = new StringBuilder(this.moduleInfo.getBaseRevision());
        String artifactRevisionIntegration = this.moduleInfo.getFileIntegrationRevision();
        if (StringUtils.isNotBlank((String)artifactRevisionIntegration)) {
            revisionBuilder.append("-").append(artifactRevisionIntegration);
        }
        return revisionBuilder.toString();
    }

    public String getClassifier() {
        return this.moduleInfo.getClassifier();
    }
}

