/*
 * Decompiled with CFR 0.152.
 */
package org.artifactory.api.rest.search.result;

import java.util.ArrayList;
import java.util.List;
import java.util.stream.Collectors;
import lombok.Generated;
import org.artifactory.api.search.stats.StatsSearchResult;
import org.jfrog.client.util.PathUtils;
import org.joda.time.format.ISODateTimeFormat;

public class LastDownloadRestResult {
    private List<DownloadedEntry> results = new ArrayList<DownloadedEntry>();

    public static String toIsoDateString(long time) {
        return ISODateTimeFormat.dateTime().print(time);
    }

    public String toString() {
        return PathUtils.collectionToDelimitedString((Iterable)this.results.stream().map(DownloadedEntry::toString).collect(Collectors.toList()));
    }

    @Generated
    public LastDownloadRestResult() {
    }

    @Generated
    public List<DownloadedEntry> getResults() {
        return this.results;
    }

    @Generated
    public void setResults(List<DownloadedEntry> results) {
        this.results = results;
    }

    @Generated
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof LastDownloadRestResult)) {
            return false;
        }
        LastDownloadRestResult other = (LastDownloadRestResult)o;
        if (!other.canEqual(this)) {
            return false;
        }
        List<DownloadedEntry> this$results = this.getResults();
        List<DownloadedEntry> other$results = other.getResults();
        return !(this$results == null ? other$results != null : !((Object)this$results).equals(other$results));
    }

    @Generated
    protected boolean canEqual(Object other) {
        return other instanceof LastDownloadRestResult;
    }

    @Generated
    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        List<DownloadedEntry> $results = this.getResults();
        result = result * 59 + ($results == null ? 43 : ((Object)$results).hashCode());
        return result;
    }

    public static class DownloadedEntry {
        private String uri;
        private long downloadCount;
        private String lastDownloaded;
        private long remoteDownloadCount;
        private String remoteLastDownloaded;

        public DownloadedEntry() {
        }

        public DownloadedEntry(String uri, StatsSearchResult result) {
            this.uri = uri;
            this.downloadCount = result.getDownloadCount();
            this.lastDownloaded = LastDownloadRestResult.toIsoDateString(result.getLastDownloaded());
            this.remoteDownloadCount = result.getRemoteDownloadCount();
            this.remoteLastDownloaded = LastDownloadRestResult.toIsoDateString(result.getRemoteLastDownloaded());
        }

        public String toString() {
            return "DownloadedEntry{uri='" + this.uri + "', downloadCount=" + this.downloadCount + ", lastDownloaded='" + this.lastDownloaded + "', remoteDownloadCount=" + this.remoteDownloadCount + ", remoteLastDownloaded='" + this.remoteLastDownloaded + "'}";
        }

        @Generated
        public String getUri() {
            return this.uri;
        }

        @Generated
        public long getDownloadCount() {
            return this.downloadCount;
        }

        @Generated
        public String getLastDownloaded() {
            return this.lastDownloaded;
        }

        @Generated
        public long getRemoteDownloadCount() {
            return this.remoteDownloadCount;
        }

        @Generated
        public String getRemoteLastDownloaded() {
            return this.remoteLastDownloaded;
        }

        @Generated
        public void setUri(String uri) {
            this.uri = uri;
        }

        @Generated
        public void setDownloadCount(long downloadCount) {
            this.downloadCount = downloadCount;
        }

        @Generated
        public void setLastDownloaded(String lastDownloaded) {
            this.lastDownloaded = lastDownloaded;
        }

        @Generated
        public void setRemoteDownloadCount(long remoteDownloadCount) {
            this.remoteDownloadCount = remoteDownloadCount;
        }

        @Generated
        public void setRemoteLastDownloaded(String remoteLastDownloaded) {
            this.remoteLastDownloaded = remoteLastDownloaded;
        }

        @Generated
        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof DownloadedEntry)) {
                return false;
            }
            DownloadedEntry other = (DownloadedEntry)o;
            if (!other.canEqual(this)) {
                return false;
            }
            String this$uri = this.getUri();
            String other$uri = other.getUri();
            if (this$uri == null ? other$uri != null : !this$uri.equals(other$uri)) {
                return false;
            }
            if (this.getDownloadCount() != other.getDownloadCount()) {
                return false;
            }
            String this$lastDownloaded = this.getLastDownloaded();
            String other$lastDownloaded = other.getLastDownloaded();
            if (this$lastDownloaded == null ? other$lastDownloaded != null : !this$lastDownloaded.equals(other$lastDownloaded)) {
                return false;
            }
            if (this.getRemoteDownloadCount() != other.getRemoteDownloadCount()) {
                return false;
            }
            String this$remoteLastDownloaded = this.getRemoteLastDownloaded();
            String other$remoteLastDownloaded = other.getRemoteLastDownloaded();
            return !(this$remoteLastDownloaded == null ? other$remoteLastDownloaded != null : !this$remoteLastDownloaded.equals(other$remoteLastDownloaded));
        }

        @Generated
        protected boolean canEqual(Object other) {
            return other instanceof DownloadedEntry;
        }

        @Generated
        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            String $uri = this.getUri();
            result = result * 59 + ($uri == null ? 43 : $uri.hashCode());
            long $downloadCount = this.getDownloadCount();
            result = result * 59 + (int)($downloadCount >>> 32 ^ $downloadCount);
            String $lastDownloaded = this.getLastDownloaded();
            result = result * 59 + ($lastDownloaded == null ? 43 : $lastDownloaded.hashCode());
            long $remoteDownloadCount = this.getRemoteDownloadCount();
            result = result * 59 + (int)($remoteDownloadCount >>> 32 ^ $remoteDownloadCount);
            String $remoteLastDownloaded = this.getRemoteLastDownloaded();
            result = result * 59 + ($remoteLastDownloaded == null ? 43 : $remoteLastDownloaded.hashCode());
            return result;
        }
    }
}

