/*
 * Decompiled with CFR 0.152.
 */
package org.artifactory.api.rest.search.result;

import com.google.common.collect.Sets;
import java.util.Set;
import org.apache.commons.lang.StringUtils;
import org.artifactory.checksum.ChecksumType;

public class BadChecksumRestSearchResult {
    private Set<SearchEntry> results = Sets.newHashSet();

    public BadChecksumRestSearchResult(Set<SearchEntry> results) {
        this.results = results;
    }

    public BadChecksumRestSearchResult() {
    }

    public Set<SearchEntry> getResults() {
        return this.results;
    }

    public void setResults(Set<SearchEntry> results) {
        this.results = results;
    }

    public void addResultAccordingToType(String uri, String clientChecksum, String serverChecksum, ChecksumType type) {
        this.results.add(SearchEntry.createSearchEntryAccordingToType(uri, serverChecksum, clientChecksum, type));
    }

    public static class SearchEntry {
        private String uri;
        private String serverMd5;
        private String clientMd5;
        private String serverSha1;
        private String clientSha1;
        private String serverSha2;
        private String clientSha2;

        SearchEntry(String uri) {
            this.uri = uri;
        }

        static SearchEntry createSearchEntryAccordingToType(String uri, String serverChecksum, String clientChecksum, ChecksumType type) {
            SearchEntry entry = new SearchEntry(uri);
            serverChecksum = StringUtils.isNotBlank((String)serverChecksum) ? serverChecksum : "";
            String string = clientChecksum = StringUtils.isNotBlank((String)clientChecksum) ? clientChecksum : "";
            if (ChecksumType.md5.equals((Object)type)) {
                entry.setServerMd5(serverChecksum);
                entry.setClientMd5(clientChecksum);
            } else if (ChecksumType.sha1.equals((Object)type)) {
                entry.setServerSha1(serverChecksum);
                entry.setClientSha1(clientChecksum);
            } else if (ChecksumType.sha256.equals((Object)type)) {
                entry.setServerSha2(serverChecksum);
                entry.setClientSha2(clientChecksum);
            } else {
                throw new AssertionError();
            }
            return entry;
        }

        private SearchEntry() {
        }

        public String getUri() {
            return this.uri;
        }

        public void setUri(String uri) {
            this.uri = uri;
        }

        public String getServerMd5() {
            return this.serverMd5;
        }

        public void setServerMd5(String serverMd5) {
            this.serverMd5 = serverMd5;
        }

        public String getClientMd5() {
            return this.clientMd5;
        }

        public void setClientMd5(String clientMd5) {
            this.clientMd5 = clientMd5;
        }

        public String getServerSha1() {
            return this.serverSha1;
        }

        public void setServerSha1(String serverSha1) {
            this.serverSha1 = serverSha1;
        }

        public String getClientSha1() {
            return this.clientSha1;
        }

        public void setClientSha1(String clientSha1) {
            this.clientSha1 = clientSha1;
        }

        public String getServerSha2() {
            return this.serverSha2;
        }

        public void setServerSha2(String serverSha2) {
            this.serverSha2 = serverSha2;
        }

        public String getClientSha2() {
            return this.clientSha2;
        }

        public void setClientSha2(String clientSha2) {
            this.clientSha2 = clientSha2;
        }
    }
}

