/*
 * Decompiled with CFR 0.152.
 */
package org.artifactory.api.rest.keys;

import java.beans.ConstructorProperties;
import java.util.regex.Pattern;
import lombok.Generated;
import org.jfrog.common.ArgUtils;

public class KeyPairModel {
    private String pairName;
    private String pairType;
    private String alias;
    private String privateKey;
    private String publicKey;
    private String passphrase;

    public void validate() {
        ArgUtils.requireNonBlank((String)this.pairName, (String)"key pair name is required");
        ArgUtils.requireMatches((String)this.pairName, (Pattern)Pattern.compile("[a-zA-Z0-9_\\-]+"), (String)"invalid key pair name, it cannot contain special characters");
        ArgUtils.requireNonBlank((String)this.pairType, (String)"key pair type is required");
        ArgUtils.requireNonBlank((String)this.alias, (String)"key pair alias is required");
        ArgUtils.requireMatches((String)this.alias, (Pattern)Pattern.compile("[^\\s]+"), (String)"invalid key pair alias, it cannot contain spaces");
        ArgUtils.requireNonBlank((String)this.privateKey, (String)"key pair private key is required");
        ArgUtils.requireNonBlank((String)this.publicKey, (String)"key pair public key is required");
    }

    @Generated
    public static KeyPairModelBuilder builder() {
        return new KeyPairModelBuilder();
    }

    @Generated
    public KeyPairModel() {
    }

    @ConstructorProperties(value={"pairName", "pairType", "alias", "privateKey", "publicKey", "passphrase"})
    @Generated
    public KeyPairModel(String pairName, String pairType, String alias, String privateKey, String publicKey, String passphrase) {
        this.pairName = pairName;
        this.pairType = pairType;
        this.alias = alias;
        this.privateKey = privateKey;
        this.publicKey = publicKey;
        this.passphrase = passphrase;
    }

    @Generated
    public String getPairName() {
        return this.pairName;
    }

    @Generated
    public String getPairType() {
        return this.pairType;
    }

    @Generated
    public String getAlias() {
        return this.alias;
    }

    @Generated
    public String getPrivateKey() {
        return this.privateKey;
    }

    @Generated
    public String getPublicKey() {
        return this.publicKey;
    }

    @Generated
    public String getPassphrase() {
        return this.passphrase;
    }

    @Generated
    public void setPairName(String pairName) {
        this.pairName = pairName;
    }

    @Generated
    public void setPairType(String pairType) {
        this.pairType = pairType;
    }

    @Generated
    public void setAlias(String alias) {
        this.alias = alias;
    }

    @Generated
    public void setPrivateKey(String privateKey) {
        this.privateKey = privateKey;
    }

    @Generated
    public void setPublicKey(String publicKey) {
        this.publicKey = publicKey;
    }

    @Generated
    public void setPassphrase(String passphrase) {
        this.passphrase = passphrase;
    }

    @Generated
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof KeyPairModel)) {
            return false;
        }
        KeyPairModel other = (KeyPairModel)o;
        if (!other.canEqual(this)) {
            return false;
        }
        String this$pairName = this.getPairName();
        String other$pairName = other.getPairName();
        if (this$pairName == null ? other$pairName != null : !this$pairName.equals(other$pairName)) {
            return false;
        }
        String this$pairType = this.getPairType();
        String other$pairType = other.getPairType();
        if (this$pairType == null ? other$pairType != null : !this$pairType.equals(other$pairType)) {
            return false;
        }
        String this$alias = this.getAlias();
        String other$alias = other.getAlias();
        if (this$alias == null ? other$alias != null : !this$alias.equals(other$alias)) {
            return false;
        }
        String this$privateKey = this.getPrivateKey();
        String other$privateKey = other.getPrivateKey();
        if (this$privateKey == null ? other$privateKey != null : !this$privateKey.equals(other$privateKey)) {
            return false;
        }
        String this$publicKey = this.getPublicKey();
        String other$publicKey = other.getPublicKey();
        if (this$publicKey == null ? other$publicKey != null : !this$publicKey.equals(other$publicKey)) {
            return false;
        }
        String this$passphrase = this.getPassphrase();
        String other$passphrase = other.getPassphrase();
        return !(this$passphrase == null ? other$passphrase != null : !this$passphrase.equals(other$passphrase));
    }

    @Generated
    protected boolean canEqual(Object other) {
        return other instanceof KeyPairModel;
    }

    @Generated
    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        String $pairName = this.getPairName();
        result = result * 59 + ($pairName == null ? 43 : $pairName.hashCode());
        String $pairType = this.getPairType();
        result = result * 59 + ($pairType == null ? 43 : $pairType.hashCode());
        String $alias = this.getAlias();
        result = result * 59 + ($alias == null ? 43 : $alias.hashCode());
        String $privateKey = this.getPrivateKey();
        result = result * 59 + ($privateKey == null ? 43 : $privateKey.hashCode());
        String $publicKey = this.getPublicKey();
        result = result * 59 + ($publicKey == null ? 43 : $publicKey.hashCode());
        String $passphrase = this.getPassphrase();
        result = result * 59 + ($passphrase == null ? 43 : $passphrase.hashCode());
        return result;
    }

    @Generated
    public String toString() {
        return "KeyPairModel(pairName=" + this.getPairName() + ", pairType=" + this.getPairType() + ", alias=" + this.getAlias() + ", privateKey=" + this.getPrivateKey() + ", publicKey=" + this.getPublicKey() + ", passphrase=" + this.getPassphrase() + ")";
    }

    @Generated
    public static class KeyPairModelBuilder {
        @Generated
        private String pairName;
        @Generated
        private String pairType;
        @Generated
        private String alias;
        @Generated
        private String privateKey;
        @Generated
        private String publicKey;
        @Generated
        private String passphrase;

        @Generated
        KeyPairModelBuilder() {
        }

        @Generated
        public KeyPairModelBuilder pairName(String pairName) {
            this.pairName = pairName;
            return this;
        }

        @Generated
        public KeyPairModelBuilder pairType(String pairType) {
            this.pairType = pairType;
            return this;
        }

        @Generated
        public KeyPairModelBuilder alias(String alias) {
            this.alias = alias;
            return this;
        }

        @Generated
        public KeyPairModelBuilder privateKey(String privateKey) {
            this.privateKey = privateKey;
            return this;
        }

        @Generated
        public KeyPairModelBuilder publicKey(String publicKey) {
            this.publicKey = publicKey;
            return this;
        }

        @Generated
        public KeyPairModelBuilder passphrase(String passphrase) {
            this.passphrase = passphrase;
            return this;
        }

        @Generated
        public KeyPairModel build() {
            return new KeyPairModel(this.pairName, this.pairType, this.alias, this.privateKey, this.publicKey, this.passphrase);
        }

        @Generated
        public String toString() {
            return "KeyPairModel.KeyPairModelBuilder(pairName=" + this.pairName + ", pairType=" + this.pairType + ", alias=" + this.alias + ", privateKey=" + this.privateKey + ", publicKey=" + this.publicKey + ", passphrase=" + this.passphrase + ")";
        }
    }
}

