/*
 * Decompiled with CFR 0.152.
 */
package org.artifactory.api.request;

import java.io.InputStream;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.Enumeration;
import java.util.Map;
import java.util.Set;
import java.util.TreeSet;
import javax.annotation.Nonnull;
import org.apache.commons.collections.iterators.IteratorEnumeration;
import org.apache.http.client.utils.DateUtils;
import org.artifactory.api.request.ArtifactoryRequestBase;
import org.artifactory.common.ConstantValues;
import org.artifactory.factory.InfoFactoryHolder;
import org.artifactory.repo.RepoPath;
import org.artifactory.request.HeadersMultiMap;

public class InternalArtifactoryRequest
extends ArtifactoryRequestBase {
    private boolean skipJarIndexing;
    private boolean trustServerChecksums;
    private boolean forceDownloadIfNewer;
    private Boolean searchForExistingResourceOnRemoteRequest;
    private Boolean replicationDownloadRequest;
    private Boolean replicationOriginatedDownloadRequest;
    private Boolean disableFolderRedirectAssertion;
    private String alternativeRemoteDownloadUrl;
    private String servletContextUrl = "";
    private Boolean replaceHeadRequestWithGet;
    private boolean skipEncoding;
    private String requestMethod;
    private boolean disableRedirect;
    private HeadersMultiMap headers = new HeadersMultiMap();
    private final Set<String> delegationAllowedHeaders;
    private String alternateRemoteSiteUrl = null;
    private boolean skipStatsUpdate = false;
    private String clientAddress = null;

    public InternalArtifactoryRequest(RepoPath repoPath, boolean disableRedirect) {
        this.processRepoPath(repoPath);
        this.setDisableRedirect(disableRedirect);
        this.delegationAllowedHeaders = new TreeSet<String>(String.CASE_INSENSITIVE_ORDER);
    }

    private void processRepoPath(RepoPath repoPath) {
        String repoKey = this.processMatrixParamsIfExist(repoPath.getRepoKey());
        String path = this.processMatrixParamsIfExist(repoPath.getPath());
        this.setRepoPath(InfoFactoryHolder.get().createRepoPath(repoKey, path));
    }

    public long getLastModified() {
        return 0L;
    }

    public boolean isHeadOnly() {
        return !ConstantValues.internalRequestDisableMethodDelegation.getBoolean() && "HEAD".equalsIgnoreCase(this.requestMethod);
    }

    public String getClientAddress() {
        return this.clientAddress;
    }

    public void setClientAddress(String clientAddress) {
        this.clientAddress = clientAddress;
    }

    public long getIfModifiedSince() {
        Enumeration<String> values = this.headers.getHeaderValues("If-Modified-Since");
        if (!values.hasMoreElements()) {
            return -1L;
        }
        Date date = DateUtils.parseDate((String)values.nextElement());
        if (date == null) {
            return -1L;
        }
        return date.getTime();
    }

    public boolean hasIfModifiedSince() {
        return this.getIfModifiedSince() != -1L;
    }

    public boolean isFromAnotherArtifactory() {
        return false;
    }

    @Override
    public boolean isRecursive() {
        return false;
    }

    public InputStream getInputStream() {
        return null;
    }

    public long getContentLength() {
        return 0L;
    }

    @Deprecated
    public Enumeration getHeaders(@Nonnull String headerName) {
        Collection values = this.headers.getHeaders().values();
        return new IteratorEnumeration(values.iterator());
    }

    public Enumeration<String> getHeadersKeys() {
        return this.headers.getHeadersKeys();
    }

    public Enumeration<String> getHeaderValues(@Nonnull String headerName) {
        return this.headers.getHeaderValues(headerName);
    }

    public void setHeader(String key, String value) {
        this.headers.setHeader(key, value);
    }

    public void addHeader(String key, String value) {
        this.headers.addHeader(key, value);
    }

    public void setHeaderEligibleForDelegation(String key, String value) {
        this.delegationAllowedHeaders.add(key);
        this.setHeader(key, value);
    }

    public void addHeaderEligibleForDelegation(String key, String value) {
        this.delegationAllowedHeaders.add(key);
        this.addHeader(key, value);
    }

    public void addHeaders(Map<String, String> headers) {
        this.headers.updateHeaders(headers);
    }

    public String getUri() {
        return "";
    }

    public String getServletContextUrl() {
        return this.servletContextUrl;
    }

    public void setServletContextUrl(String servletContextUrl) {
        this.servletContextUrl = servletContextUrl;
    }

    public void setSkipJarIndexing(boolean skipJarIndexing) {
        this.skipJarIndexing = skipJarIndexing;
    }

    public void setTrustServerChecksums(boolean trustServerChecksums) {
        this.trustServerChecksums = trustServerChecksums;
    }

    public boolean isSkipEncoding() {
        return this.skipEncoding;
    }

    public boolean isDisableRedirect() {
        return this.disableRedirect;
    }

    public boolean isSkipJarIndexing() {
        return this.skipJarIndexing;
    }

    public boolean isTrustServerChecksums() {
        return this.trustServerChecksums;
    }

    public boolean isForceDownloadIfNewer() {
        return this.forceDownloadIfNewer;
    }

    public void setForceDownloadIfNewer(boolean forceDownloadIfNewer) {
        this.forceDownloadIfNewer = forceDownloadIfNewer;
    }

    public void setSearchForExistingResourceOnRemoteRequest(boolean searchForExistingResourceOnRemoteRequest) {
        this.searchForExistingResourceOnRemoteRequest = searchForExistingResourceOnRemoteRequest;
    }

    public void setAlternativeRemoteDownloadUrl(String alternativeRemoteDownloadUrl) {
        this.alternativeRemoteDownloadUrl = alternativeRemoteDownloadUrl;
    }

    public void setReplicationDownloadRequest(Boolean replicationDownloadRequest) {
        this.replicationDownloadRequest = replicationDownloadRequest;
    }

    public void setReplicationOriginatedDownloadRequest(Boolean replicationOriginatedDownloadRequest) {
        this.replicationOriginatedDownloadRequest = replicationOriginatedDownloadRequest;
    }

    public void setDisableFolderRedirectAssertion(Boolean disableFolderRedirectAssertion) {
        this.disableFolderRedirectAssertion = disableFolderRedirectAssertion;
    }

    public void setReplaceHeadRequestWithGet(Boolean replaceHeadRequestWithGet) {
        this.replaceHeadRequestWithGet = replaceHeadRequestWithGet;
    }

    public void setRequestMethod(String requestMethod) {
        this.requestMethod = requestMethod;
    }

    public void setDisableRedirect(boolean disableRedirect) {
        this.disableRedirect = disableRedirect;
    }

    public void setAlternateRemoteSiteUrl(String remoteResourceUrl) {
        this.alternateRemoteSiteUrl = remoteResourceUrl;
    }

    public void setSkipEncoding(boolean skipEncoding) {
        this.skipEncoding = skipEncoding;
    }

    @Override
    public void setZipResourcePath(String zipResourcePath) {
        super.setZipResourcePath(zipResourcePath);
    }

    @Override
    public String getParameter(String name) {
        if ("artifactory.skipJarIndexing".equals(name)) {
            return String.valueOf(this.skipJarIndexing);
        }
        if ("artifactory.forceDownloadIfNewer".equals(name)) {
            return String.valueOf(this.forceDownloadIfNewer);
        }
        if ("artifactory.searchForExistingResourceOnRemoteRequest".equals(name) && this.searchForExistingResourceOnRemoteRequest != null) {
            return String.valueOf(this.searchForExistingResourceOnRemoteRequest);
        }
        if ("artifactory.alternativeRemoteDownloadUrl".equals(name)) {
            return this.alternativeRemoteDownloadUrl;
        }
        if ("artifactory.replicationDownloadRequest".equals(name)) {
            return String.valueOf(this.replicationDownloadRequest);
        }
        if ("artifactory.replicationOriginatedDownloadRequest".equals(name)) {
            return String.valueOf(this.replicationOriginatedDownloadRequest);
        }
        if ("artifactory.disableFolderRedirectAssertion".equals(name)) {
            return String.valueOf(this.disableFolderRedirectAssertion);
        }
        if ("artifactory.replaceHeadInRetrieveInfoWithGet".equals(name)) {
            return String.valueOf(this.replaceHeadRequestWithGet);
        }
        if ("artifactory.skipEncoding".equals(name)) {
            return String.valueOf(this.skipEncoding);
        }
        if ("artifactory.alternativeRemoteSiteUrl".equals(name) && this.alternateRemoteSiteUrl != null) {
            return String.valueOf(this.alternateRemoteSiteUrl);
        }
        if ("artifactory.disableRedirect".equals(name)) {
            return String.valueOf(this.disableRedirect);
        }
        return null;
    }

    @Override
    public String[] getParameterValues(String name) {
        String val = this.getParameter(name);
        if (val != null) {
            return new String[]{val};
        }
        return super.getParameterValues(name);
    }

    public Set<String> getDelegationAllowedHeaders() {
        return Collections.unmodifiableSet(this.delegationAllowedHeaders);
    }

    public boolean isSkipStatsUpdate() {
        return this.skipStatsUpdate;
    }

    public void setSkipStatsUpdate(boolean skipStatsUpdate) {
        this.skipStatsUpdate = skipStatsUpdate;
    }
}

