/*
 * Decompiled with CFR 0.152.
 */
package org.artifactory.api.request;

import java.io.UnsupportedEncodingException;
import java.net.URLDecoder;
import java.util.Collections;
import java.util.Enumeration;
import java.util.Map;
import org.apache.commons.lang.StringUtils;
import org.artifactory.common.home.ArtifactoryHome;
import org.artifactory.factory.InfoFactoryHolder;
import org.artifactory.md.Properties;
import org.artifactory.mime.NamingUtils;
import org.artifactory.repo.RepoPath;
import org.artifactory.request.ArtifactoryRequest;
import org.jfrog.client.util.PathUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class ArtifactoryRequestBase
implements ArtifactoryRequest {
    private static final Logger log = LoggerFactory.getLogger(ArtifactoryRequestBase.class);
    private RepoPath repoPath;
    private Properties properties = (Properties)InfoFactoryHolder.get().createProperties();
    private String zipResourcePath;
    private long modificationTime = -1L;

    public RepoPath getRepoPath() {
        return this.repoPath;
    }

    @Override
    public String getRepoKey() {
        return this.repoPath.getRepoKey();
    }

    @Override
    public String getPath() {
        return this.repoPath.getPath();
    }

    public Properties getProperties() {
        return this.properties;
    }

    public boolean hasProperties() {
        return !this.properties.isEmpty();
    }

    public String getZipResourcePath() {
        return this.zipResourcePath;
    }

    public boolean isZipResourceRequest() {
        return StringUtils.isNotBlank((String)this.zipResourcePath);
    }

    public boolean isNoneMatch(String etag) {
        if (StringUtils.isBlank((String)etag)) {
            return true;
        }
        Enumeration ifNoneMatch = this.getHeaders("If-None-Match");
        while (ifNoneMatch != null && ifNoneMatch.hasMoreElements()) {
            Object requestIfNoneMatch = ifNoneMatch.nextElement();
            if (!etag.equals(requestIfNoneMatch)) continue;
            return false;
        }
        return true;
    }

    public boolean hasIfNoneMatch() {
        return this.getHeader("If-None-Match") != null;
    }

    @Override
    public boolean isMetadata() {
        return NamingUtils.isMetadata((String)this.getPath());
    }

    public boolean isChecksum() {
        return NamingUtils.isChecksum((String)this.getPath()) || NamingUtils.isChecksum((String)this.zipResourcePath);
    }

    @Override
    public String getName() {
        return PathUtils.getFileName((String)this.getPath());
    }

    public boolean isNewerThan(long resourceLastModified) {
        long modificationTime = this.getModificationTime();
        log.debug("Check isNewerThan. resourceLastModified={}, roundedResourceLastModified={}, modificationTime={}", new Object[]{resourceLastModified, ArtifactoryRequestBase.roundMillis(resourceLastModified), modificationTime});
        return resourceLastModified >= 0L && ArtifactoryRequestBase.roundMillis(resourceLastModified) <= modificationTime;
    }

    @Override
    public long getModificationTime() {
        if (this.modificationTime < 0L) {
            long lastModified = this.getLastModified();
            long ifModifiedSince = this.getIfModifiedSince();
            if (lastModified < 0L && ifModifiedSince < 0L) {
                if (log.isDebugEnabled()) {
                    log.debug("Neither If-Modified-Since nor Last-Modified are set");
                }
                return -1L;
            }
            if (lastModified >= 0L && ifModifiedSince >= 0L && lastModified != ifModifiedSince && log.isDebugEnabled()) {
                log.warn("If-Modified-Since (" + ifModifiedSince + ") AND Last-Modified (" + lastModified + ") both set and unequal");
            }
            this.modificationTime = Math.max(lastModified, ifModifiedSince);
        }
        return this.modificationTime;
    }

    protected void setRepoPath(RepoPath repoPath) {
        this.repoPath = repoPath;
    }

    protected void setZipResourcePath(String zipResourcePath) {
        this.zipResourcePath = zipResourcePath;
    }

    public static long roundMillis(long time) {
        if (time != -1L) {
            return time / 1000L * 1000L;
        }
        return time;
    }

    public String getParameter(String name) {
        return null;
    }

    public Map<String, String[]> getParameters() {
        return Collections.emptyMap();
    }

    public String[] getParameterValues(String name) {
        return new String[0];
    }

    protected RepoPath calculateRepoPath(String requestPath) throws UnsupportedEncodingException {
        int pathEndIndex;
        int repoKeyStartIndex;
        int pathStartIndex;
        String repoKey = PathUtils.getFirstPathElement((String)requestPath);
        if (NamingUtils.isMetadata((String)repoKey)) {
            repoKey = NamingUtils.stripMetadataFromPath((String)repoKey);
            pathStartIndex = repoKey.length() + ":".length();
        } else if ("list".equals(repoKey)) {
            repoKeyStartIndex = requestPath.indexOf("list") + "list".length() + 1;
            if (repoKeyStartIndex > requestPath.length()) {
                --repoKeyStartIndex;
            }
            repoKey = PathUtils.getFirstPathElement((String)requestPath.substring(repoKeyStartIndex));
            pathStartIndex = repoKeyStartIndex + repoKey.length() + 1;
        } else if ("simple".equals(repoKey)) {
            repoKeyStartIndex = requestPath.indexOf("simple") + "simple".length() + 1;
            if (repoKeyStartIndex > requestPath.length()) {
                --repoKeyStartIndex;
            }
            repoKey = PathUtils.getFirstPathElement((String)requestPath.substring(repoKeyStartIndex));
            pathStartIndex = repoKeyStartIndex + repoKey.length() + 1;
        } else {
            pathStartIndex = requestPath.startsWith("/") ? repoKey.length() + 2 : repoKey.length() + 1;
        }
        repoKey = this.processMatrixParamsIfExist(repoKey);
        repoKey = URLDecoder.decode(repoKey, "UTF-8");
        String substTargetRepo = (String)ArtifactoryHome.get().getArtifactoryProperties().getSubstituteRepoKeys().get(repoKey);
        if (substTargetRepo != null) {
            repoKey = substTargetRepo;
        }
        String path = pathStartIndex < (pathEndIndex = requestPath.length()) ? requestPath.substring(pathStartIndex, pathEndIndex) : "";
        path = this.handleDotSegments(path);
        boolean endsWithSlash = !path.contains(";") ? path.endsWith("/") : path.substring(0, path.indexOf(";")).endsWith("/");
        path = path.endsWith("/") ? path.substring(0, path.length() - 1) : path;
        path = this.processMatrixParamsIfExist(path);
        path = URLDecoder.decode(path.replace("+", "%2B"), "UTF-8").replace("%2B", "+");
        path = this.processZipResourcePathIfExist(path);
        return InfoFactoryHolder.get().createRepoPath(repoKey, path, endsWithSlash);
    }

    private String handleDotSegments(String requestPath) {
        int matrixParamStart = ((String)requestPath).indexOf(";");
        if (matrixParamStart > 0 && !((String)requestPath).endsWith(";")) {
            String props = ((String)requestPath).substring(matrixParamStart);
            requestPath = ((String)requestPath).substring(0, matrixParamStart);
            requestPath = this.removeDotSegments((String)requestPath);
            requestPath = (String)requestPath + props;
        } else {
            requestPath = this.removeDotSegments((String)requestPath);
        }
        return requestPath;
    }

    private String removeDotSegments(String requestPath) {
        if (requestPath.contains("/./")) {
            requestPath = requestPath.replace("/./", "/");
        }
        if (requestPath.endsWith("/.")) {
            requestPath = requestPath.replace("/.", "/");
        }
        if (requestPath.equals("./")) {
            requestPath = requestPath.replace("./", "/");
        }
        return requestPath;
    }

    protected String processMatrixParamsIfExist(String fragment) {
        int matrixParamStart = fragment.indexOf(";");
        if (matrixParamStart > 0) {
            ArtifactoryRequestBase.processMatrixParams(this.properties, fragment.substring(matrixParamStart));
            return fragment.substring(0, matrixParamStart);
        }
        return fragment;
    }

    private String processZipResourcePathIfExist(String path) {
        String[] splitPath = PathUtils.splitZipResourcePathIfExist((String)path, (boolean)false);
        if (splitPath.length > 1) {
            this.zipResourcePath = splitPath[1];
        }
        return splitPath[0];
    }

    public String toString() {
        return "source=" + this.getClientAddress() + ", path=" + this.getPath() + ", lastModified=" + this.getLastModified() + ", ifModifiedSince=" + this.getIfModifiedSince();
    }

    public static void processMatrixParams(Properties propertyCollection, String matrixParams) {
        int matrixParamEnd;
        int matrixParamStart = 0;
        do {
            String param;
            int equals;
            if ((matrixParamEnd = matrixParams.indexOf(";", matrixParamStart + 1)) < 0) {
                matrixParamEnd = matrixParams.length();
            }
            if ((equals = (param = matrixParams.substring(matrixParamStart + 1, matrixParamEnd)).indexOf(61)) > 0) {
                String key = param.substring(0, equals);
                String value = param.substring(equals + 1);
                try {
                    value = URLDecoder.decode(value, "UTF-8");
                }
                catch (UnsupportedEncodingException e) {
                    log.warn("Encoding not supported: {}. Using original value", (Object)e.getMessage());
                }
                propertyCollection.put(key, value);
                continue;
            }
            if (param.length() <= 0) continue;
            propertyCollection.put(param, "");
        } while ((matrixParamStart = matrixParamEnd) > 0 && matrixParamStart < matrixParams.length());
    }

    @Override
    public boolean isDirectoryRequest() {
        String uri = this.getUri();
        boolean endsWithSlash = uri.endsWith("/");
        boolean containsSlashWithSemicolon = uri.contains("/;");
        boolean lastSlashIndex = uri.lastIndexOf("/;") >= uri.lastIndexOf("/");
        return endsWithSlash || containsSlashWithSemicolon && lastSlashIndex;
    }
}

