/*
 * Decompiled with CFR 0.152.
 */
package org.artifactory.api.module.regex;

import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.artifactory.api.module.regex.NamedMatcher;

public class NamedPattern {
    private static final Pattern NAMED_GROUP_PATTERN = Pattern.compile("\\(\\?<(\\w+)>");
    private Pattern pattern;
    private String namedPattern;
    private List<String> groupNames;

    public static NamedPattern compile(String regex) {
        return new NamedPattern(regex, 0);
    }

    public static NamedPattern compile(String regex, int flags) {
        return new NamedPattern(regex, flags);
    }

    private NamedPattern(String regex, int i) {
        this.namedPattern = regex;
        this.pattern = NamedPattern.buildStandardPattern(regex);
        this.groupNames = NamedPattern.extractGroupNames(regex);
    }

    public int flags() {
        return this.pattern.flags();
    }

    public NamedMatcher matcher(CharSequence input) {
        return new NamedMatcher(this, input);
    }

    Pattern pattern() {
        return this.pattern;
    }

    public String standardPattern() {
        return this.pattern.pattern();
    }

    public String namedPattern() {
        return this.namedPattern;
    }

    public List<String> groupNames() {
        return this.groupNames;
    }

    public String[] split(CharSequence input, int limit) {
        return this.pattern.split(input, limit);
    }

    public String[] split(CharSequence input) {
        return this.pattern.split(input);
    }

    public String toString() {
        return this.namedPattern;
    }

    static List<String> extractGroupNames(String namedPattern) {
        ArrayList groupNames = Lists.newArrayList();
        Matcher matcher = NAMED_GROUP_PATTERN.matcher(namedPattern);
        while (matcher.find()) {
            groupNames.add(matcher.group(1));
        }
        return groupNames;
    }

    static Pattern buildStandardPattern(String namedPattern) {
        return Pattern.compile(NAMED_GROUP_PATTERN.matcher(namedPattern).replaceAll("("));
    }
}

