/*
 * Decompiled with CFR 0.152.
 */
package org.artifactory.api.module;

import java.util.Map;
import org.apache.commons.lang.StringUtils;
import org.artifactory.fs.FileLayoutInfo;

public class ModuleInfo
implements FileLayoutInfo {
    private String organization;
    private String module;
    private String baseRevision;
    private String folderIntegrationRevision;
    private String fileIntegrationRevision;
    private String classifier;
    private String ext;
    private String type;
    private Map<String, String> customFields;

    public ModuleInfo() {
    }

    public ModuleInfo(String organization, String module, String baseRevision, String folderIntegrationRevision, String fileIntegrationRevision, String classifier, String ext, String type, Map<String, String> customFields) {
        this.organization = organization;
        this.module = module;
        this.baseRevision = baseRevision;
        this.folderIntegrationRevision = folderIntegrationRevision;
        this.fileIntegrationRevision = fileIntegrationRevision;
        this.classifier = classifier;
        this.ext = ext;
        this.type = type;
        this.customFields = customFields;
    }

    public String getOrganization() {
        return this.organization;
    }

    public String getModule() {
        return this.module;
    }

    public String getBaseRevision() {
        return this.baseRevision;
    }

    public String getFolderIntegrationRevision() {
        return this.folderIntegrationRevision;
    }

    public String getFileIntegrationRevision() {
        return this.fileIntegrationRevision;
    }

    public String getClassifier() {
        return this.classifier;
    }

    public String getExt() {
        return this.ext;
    }

    public String getType() {
        return this.type;
    }

    public Map<String, String> getCustomFields() {
        return this.customFields;
    }

    public String getCustomField(String tokenName) {
        if (this.customFields == null) {
            return null;
        }
        return this.customFields.get(tokenName);
    }

    public boolean isValid() {
        return StringUtils.isNotBlank((String)this.organization) && StringUtils.isNotBlank((String)this.module) && StringUtils.isNotBlank((String)this.baseRevision);
    }

    public String getPrettyModuleId() {
        String type;
        String classifier;
        if (StringUtils.isBlank((String)this.getOrganization()) || StringUtils.isBlank((String)this.getModule()) || StringUtils.isBlank((String)this.getBaseRevision())) {
            return "null:null:null";
        }
        StringBuilder moduleIdBuilder = new StringBuilder(this.getOrganization()).append(":").append(this.getModule()).append(":").append(this.getBaseRevision());
        if (StringUtils.isNotBlank((String)this.getFileIntegrationRevision())) {
            moduleIdBuilder.append("-").append(this.getFileIntegrationRevision());
        }
        if (StringUtils.isNotBlank((String)(classifier = this.getClassifier()))) {
            moduleIdBuilder.append(":").append(classifier);
        }
        if (StringUtils.isNotBlank((String)(type = this.getType()))) {
            moduleIdBuilder.append(":").append(type);
        }
        return moduleIdBuilder.toString();
    }

    public boolean isIntegration() {
        return StringUtils.isNotBlank((String)this.getFolderIntegrationRevision()) || StringUtils.isNotBlank((String)this.getFileIntegrationRevision());
    }

    public String toString() {
        return "organization = " + this.organization + ", module = " + this.module + ", baseRevision = " + this.baseRevision + ", folderIntegrationRevision = " + this.folderIntegrationRevision + ", fileIntegrationRevision = " + this.fileIntegrationRevision + ", classifier = " + this.classifier + ", ext = " + this.ext + ", type = " + this.type;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof ModuleInfo)) {
            return false;
        }
        ModuleInfo that = (ModuleInfo)o;
        if (this.fileIntegrationRevision != null ? !this.fileIntegrationRevision.equals(that.fileIntegrationRevision) : that.fileIntegrationRevision != null) {
            return false;
        }
        if (this.classifier != null ? !this.classifier.equals(that.classifier) : that.classifier != null) {
            return false;
        }
        if (this.ext != null ? !this.ext.equals(that.ext) : that.ext != null) {
            return false;
        }
        if (this.module != null ? !this.module.equals(that.module) : that.module != null) {
            return false;
        }
        if (this.organization != null ? !this.organization.equals(that.organization) : that.organization != null) {
            return false;
        }
        if (this.folderIntegrationRevision != null ? !this.folderIntegrationRevision.equals(that.folderIntegrationRevision) : that.folderIntegrationRevision != null) {
            return false;
        }
        if (this.baseRevision != null ? !this.baseRevision.equals(that.baseRevision) : that.baseRevision != null) {
            return false;
        }
        return this.type != null ? this.type.equals(that.type) : that.type == null;
    }

    public int hashCode() {
        int result = this.organization != null ? this.organization.hashCode() : 0;
        result = 31 * result + (this.module != null ? this.module.hashCode() : 0);
        result = 31 * result + (this.baseRevision != null ? this.baseRevision.hashCode() : 0);
        result = 31 * result + (this.folderIntegrationRevision != null ? this.folderIntegrationRevision.hashCode() : 0);
        result = 31 * result + (this.fileIntegrationRevision != null ? this.fileIntegrationRevision.hashCode() : 0);
        result = 31 * result + (this.classifier != null ? this.classifier.hashCode() : 0);
        result = 31 * result + (this.ext != null ? this.ext.hashCode() : 0);
        result = 31 * result + (this.type != null ? this.type.hashCode() : 0);
        return result;
    }
}

