/*
 * Decompiled with CFR 0.152.
 */
package org.artifactory.api.license;

import com.thoughtworks.xstream.annotations.XStreamAlias;
import java.io.Serializable;
import java.util.regex.Pattern;
import org.apache.commons.lang.StringUtils;

@XStreamAlias(value="license")
public class LicenseInfo
implements Serializable {
    public static final String NOT_FOUND = "Not Found";
    public static final String UNKNOWN = "Unknown";
    public static final String ROOT = "license";
    private static final String NOT_SEARCHED = "Not Searched";
    private String name = "";
    private String longName = "";
    private String url = "";
    private String regexp = "";
    private String comments = "";
    private boolean approved = false;
    private boolean unknown;
    private boolean validLicense;
    private boolean found;
    private boolean notFound;
    private boolean notSearched;

    public LicenseInfo(String name, String longName, String url) {
        this.name = name;
        this.longName = longName;
        this.url = url;
    }

    public LicenseInfo() {
    }

    public boolean isApproved() {
        return this.approved;
    }

    public void setApproved(boolean approved) {
        this.approved = approved;
    }

    public String getComments() {
        return this.comments;
    }

    public void setComments(String comments) {
        this.comments = comments;
    }

    public String getRegexp() {
        return this.regexp;
    }

    public void setRegexp(String regexp) {
        this.regexp = regexp;
    }

    public String getLongName() {
        return this.longName;
    }

    public void setLongName(String longName) {
        this.longName = longName;
    }

    public String getUrl() {
        return this.url;
    }

    public void setUrl(String url) {
        this.url = url;
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public boolean isValidLicense() {
        return !this.isUnknown() && this.isFound();
    }

    public boolean matchesLicense(String otherLicense) {
        if (StringUtils.isBlank((String)otherLicense)) {
            return false;
        }
        if (otherLicense.equalsIgnoreCase(this.getName())) {
            return true;
        }
        if (StringUtils.isNotBlank((String)this.regexp)) {
            return Pattern.compile(this.regexp, 2).matcher(otherLicense).matches();
        }
        return false;
    }

    public static LicenseInfo createNotFound() {
        return new LicenseInfo(NOT_FOUND, "", "");
    }

    public static LicenseInfo createNotSearched() {
        return new LicenseInfo(NOT_SEARCHED, "", "");
    }

    public boolean isNotFound() {
        return this.name.equals(NOT_FOUND);
    }

    public boolean isFound() {
        return !this.isNotFound() && !this.isNotSearched();
    }

    public static LicenseInfo createUnknown(String name, String url) {
        return new LicenseInfo(UNKNOWN, name, url);
    }

    public static LicenseInfo createEmptyUnknown() {
        return new LicenseInfo(NOT_SEARCHED, "", "");
    }

    public boolean isUnknown() {
        return this.name.equals(UNKNOWN);
    }

    public boolean isNotSearched() {
        return this.name.equals(NOT_SEARCHED);
    }

    public static boolean isUnknownLicenseName(String licenseName) {
        return licenseName.equalsIgnoreCase(UNKNOWN);
    }

    public static boolean isNotFoundLicenseName(String licenseName) {
        return licenseName.equalsIgnoreCase(NOT_FOUND);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        LicenseInfo that = (LicenseInfo)o;
        if (this.isNotFound() && that.isNotFound()) {
            return true;
        }
        if (this.isNotSearched() && that.isNotSearched()) {
            return true;
        }
        if (this.isUnknown() && that.isUnknown()) {
            return this.longName != null ? this.longName.equals(that.longName) : that.longName != null;
        }
        return this.name != null ? this.name.equals(that.name) : that.name != null;
    }

    public int hashCode() {
        int result = this.name.hashCode();
        result = this.longName != null ? 31 * result + this.longName.hashCode() : result;
        return result;
    }

    public String toString() {
        return "LicenseInfo{name='" + this.name + "', longName='" + this.longName + "', url='" + this.url + "'}";
    }
}

