/*
 * Decompiled with CFR 0.152.
 */
package org.artifactory.api.component;

import java.beans.ConstructorProperties;
import java.io.IOException;
import lombok.Generated;
import org.artifactory.descriptor.repo.RepoType;
import org.artifactory.mime.MimeType;
import org.codehaus.jackson.map.ObjectMapper;
import org.codehaus.jackson.map.annotate.JsonSerialize;

@JsonSerialize
public class ComponentDetails {
    private static ComponentDetails DEFAULT_COMPONENT_DETAILS = ComponentDetails.builder().build();
    private static final ObjectMapper mapper = new ObjectMapper();
    private String name;
    private String version;
    private RepoType componentType;
    private String extension;
    private String mimeType;

    public static ComponentDetails fromJson(String jsonString) {
        try {
            return (ComponentDetails)mapper.readValue(jsonString, ComponentDetails.class);
        }
        catch (IOException e) {
            throw new IllegalArgumentException(e);
        }
    }

    public static String toJson(ComponentDetails componentDetails) {
        try {
            return mapper.writeValueAsString((Object)componentDetails);
        }
        catch (IOException e) {
            throw new IllegalArgumentException(e);
        }
    }

    public static ComponentDetails getDefaultComponentDetails() {
        return DEFAULT_COMPONENT_DETAILS;
    }

    @Generated
    private static String $default$mimeType() {
        return MimeType.def.getType();
    }

    @Generated
    public static ComponentDetailsBuilder builder() {
        return new ComponentDetailsBuilder();
    }

    @Generated
    public String getName() {
        return this.name;
    }

    @Generated
    public String getVersion() {
        return this.version;
    }

    @Generated
    public RepoType getComponentType() {
        return this.componentType;
    }

    @Generated
    public String getExtension() {
        return this.extension;
    }

    @Generated
    public String getMimeType() {
        return this.mimeType;
    }

    @Generated
    public void setName(String name) {
        this.name = name;
    }

    @Generated
    public void setVersion(String version) {
        this.version = version;
    }

    @Generated
    public void setComponentType(RepoType componentType) {
        this.componentType = componentType;
    }

    @Generated
    public void setExtension(String extension) {
        this.extension = extension;
    }

    @Generated
    public void setMimeType(String mimeType) {
        this.mimeType = mimeType;
    }

    @Generated
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof ComponentDetails)) {
            return false;
        }
        ComponentDetails other = (ComponentDetails)o;
        if (!other.canEqual(this)) {
            return false;
        }
        String this$name = this.getName();
        String other$name = other.getName();
        if (this$name == null ? other$name != null : !this$name.equals(other$name)) {
            return false;
        }
        String this$version = this.getVersion();
        String other$version = other.getVersion();
        if (this$version == null ? other$version != null : !this$version.equals(other$version)) {
            return false;
        }
        RepoType this$componentType = this.getComponentType();
        RepoType other$componentType = other.getComponentType();
        if (this$componentType == null ? other$componentType != null : !this$componentType.equals(other$componentType)) {
            return false;
        }
        String this$extension = this.getExtension();
        String other$extension = other.getExtension();
        if (this$extension == null ? other$extension != null : !this$extension.equals(other$extension)) {
            return false;
        }
        String this$mimeType = this.getMimeType();
        String other$mimeType = other.getMimeType();
        return !(this$mimeType == null ? other$mimeType != null : !this$mimeType.equals(other$mimeType));
    }

    @Generated
    protected boolean canEqual(Object other) {
        return other instanceof ComponentDetails;
    }

    @Generated
    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        String $name = this.getName();
        result = result * 59 + ($name == null ? 43 : $name.hashCode());
        String $version = this.getVersion();
        result = result * 59 + ($version == null ? 43 : $version.hashCode());
        RepoType $componentType = this.getComponentType();
        result = result * 59 + ($componentType == null ? 43 : $componentType.hashCode());
        String $extension = this.getExtension();
        result = result * 59 + ($extension == null ? 43 : $extension.hashCode());
        String $mimeType = this.getMimeType();
        result = result * 59 + ($mimeType == null ? 43 : $mimeType.hashCode());
        return result;
    }

    @Generated
    public String toString() {
        return "ComponentDetails(name=" + this.getName() + ", version=" + this.getVersion() + ", componentType=" + this.getComponentType() + ", extension=" + this.getExtension() + ", mimeType=" + this.getMimeType() + ")";
    }

    @ConstructorProperties(value={"name", "version", "componentType", "extension", "mimeType"})
    @Generated
    public ComponentDetails(String name, String version, RepoType componentType, String extension, String mimeType) {
        this.name = name;
        this.version = version;
        this.componentType = componentType;
        this.extension = extension;
        this.mimeType = mimeType;
    }

    @Generated
    public ComponentDetails() {
        this.mimeType = ComponentDetails.$default$mimeType();
    }

    @Generated
    public static class ComponentDetailsBuilder {
        @Generated
        private String name;
        @Generated
        private String version;
        @Generated
        private RepoType componentType;
        @Generated
        private String extension;
        @Generated
        private boolean mimeType$set;
        @Generated
        private String mimeType$value;

        @Generated
        ComponentDetailsBuilder() {
        }

        @Generated
        public ComponentDetailsBuilder name(String name) {
            this.name = name;
            return this;
        }

        @Generated
        public ComponentDetailsBuilder version(String version) {
            this.version = version;
            return this;
        }

        @Generated
        public ComponentDetailsBuilder componentType(RepoType componentType) {
            this.componentType = componentType;
            return this;
        }

        @Generated
        public ComponentDetailsBuilder extension(String extension) {
            this.extension = extension;
            return this;
        }

        @Generated
        public ComponentDetailsBuilder mimeType(String mimeType) {
            this.mimeType$value = mimeType;
            this.mimeType$set = true;
            return this;
        }

        @Generated
        public ComponentDetails build() {
            String mimeType$value = this.mimeType$value;
            if (!this.mimeType$set) {
                mimeType$value = ComponentDetails.$default$mimeType();
            }
            return new ComponentDetails(this.name, this.version, this.componentType, this.extension, mimeType$value);
        }

        @Generated
        public String toString() {
            return "ComponentDetails.ComponentDetailsBuilder(name=" + this.name + ", version=" + this.version + ", componentType=" + this.componentType + ", extension=" + this.extension + ", mimeType$value=" + this.mimeType$value + ")";
        }
    }
}

