/*
 * Decompiled with CFR 0.152.
 */
package org.artifactory.api.common;

import com.google.common.collect.Lists;
import com.thoughtworks.xstream.annotations.XStreamAlias;
import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import java.util.concurrent.ArrayBlockingQueue;
import javax.annotation.Nonnull;
import org.apache.commons.lang.StringUtils;
import org.artifactory.api.build.StatusEntryComparators;
import org.artifactory.common.MutableStatusHolder;
import org.artifactory.common.StatusEntry;
import org.artifactory.common.StatusEntryLevel;
import org.artifactory.exception.CancelException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@XStreamAlias(value="status")
public class BasicStatusHolder
implements MutableStatusHolder {
    private static final Logger log = LoggerFactory.getLogger(BasicStatusHolder.class);
    private final ArrayBlockingQueue<StatusEntry> statusEntries = new ArrayBlockingQueue(500);
    private final ArrayBlockingQueue<StatusEntry> errorEntries = new ArrayBlockingQueue(2000);
    private final ArrayBlockingQueue<StatusEntry> warningEntries = new ArrayBlockingQueue(100);
    private static final int CODE_OK = 200;
    private static final int CODE_INTERNAL_ERROR = 500;
    private boolean activateLogging = true;
    private boolean fastFail = false;
    protected boolean verbose = false;
    private StatusEntry lastStatusEntry;
    private StatusEntry lastErrorStatusEntry;
    private StatusEntry lastWarningStatusEntry;

    public void setFastFail(boolean fastFail) {
        this.fastFail = fastFail;
    }

    public void setVerbose(boolean verbose) {
        this.verbose = verbose;
    }

    private boolean isFastFail() {
        return this.fastFail;
    }

    public boolean isVerbose() {
        return this.verbose;
    }

    public StatusEntry getLastError() {
        return this.lastErrorStatusEntry;
    }

    public StatusEntry getLastWarning() {
        return this.lastWarningStatusEntry;
    }

    public StatusEntry getLastStatusEntry() {
        return this.lastStatusEntry;
    }

    public final void debug(String statusMsg, @Nonnull Logger logger) {
        this.logEntryAndAddEntry(new StatusEntry(200, StatusEntryLevel.DEBUG, statusMsg, null), logger);
    }

    public final void setDebug(String statusMsg, int statusCode, @Nonnull Logger logger) {
        this.logEntryAndAddEntry(new StatusEntry(statusCode, StatusEntryLevel.DEBUG, statusMsg, null), logger);
    }

    public final void status(String statusMsg, @Nonnull Logger logger) {
        this.status(statusMsg, 200, logger);
    }

    public final void status(String statusMsg, int statusCode, @Nonnull Logger logger) {
        this.logEntryAndAddEntry(new StatusEntry(statusCode, statusMsg), logger);
    }

    public void error(String status, Throwable throwable, @Nonnull Logger logger) {
        this.error(status, 500, throwable, logger);
    }

    public void error(String statusMsg, @Nonnull Logger logger) {
        this.error(statusMsg, 500, null, logger);
    }

    public void error(String statusMsg, int statusCode, @Nonnull Logger logger) {
        this.error(statusMsg, statusCode, null, logger);
    }

    public void error(String statusMsg, int statusCode, Throwable throwable, @Nonnull Logger logger) {
        this.addError(new StatusEntry(statusCode, StatusEntryLevel.ERROR, statusMsg, throwable), logger);
    }

    public void warn(String statusMsg, Throwable throwable, @Nonnull Logger logger) {
        this.addError(new StatusEntry(500, StatusEntryLevel.WARNING, statusMsg, throwable), logger);
    }

    public void warn(String statusMsg, int statusCode, Throwable throwable, @Nonnull Logger logger) {
        this.addError(new StatusEntry(statusCode, StatusEntryLevel.WARNING, statusMsg, throwable), logger);
    }

    public void warn(String statusMsg, @Nonnull Logger logger) {
        this.addError(new StatusEntry(500, StatusEntryLevel.WARNING, statusMsg, null), logger);
    }

    public void warn(String statusMsg, int statusCode, @Nonnull Logger logger) {
        this.addError(new StatusEntry(statusCode, StatusEntryLevel.WARNING, statusMsg, null), logger);
    }

    private void addError(@Nonnull StatusEntry errorEntry, @Nonnull Logger logger) {
        if (this.isActivateLogging()) {
            this.logEntry(errorEntry, logger);
        }
        this.addStatusEntry(errorEntry);
        if (!errorEntry.isWarning() && this.isFastFail()) {
            Throwable throwable = errorEntry.getException();
            if (throwable != null) {
                if (throwable instanceof RuntimeException) {
                    throw (RuntimeException)throwable;
                }
                if (throwable instanceof Error) {
                    throw (Error)throwable;
                }
                throw new RuntimeException("Fast fail exception: " + errorEntry.getMessage(), throwable);
            }
            throw new RuntimeException("Fast fail exception: " + errorEntry.getMessage());
        }
    }

    protected void logEntry(@Nonnull StatusEntry entry, @Nonnull Logger logger) {
        if (this.isVerbose()) {
            this.doLogEntry(entry, log);
        } else {
            this.doLogEntry(entry, logger);
        }
    }

    void doLogEntry(@Nonnull StatusEntry entry, @Nonnull Logger logger) {
        Object statusMessage = entry.getMessage();
        Throwable throwable = entry.getException();
        if (!this.isVerbose() && throwable != null) {
            statusMessage = (String)statusMessage + ": " + (StringUtils.isNotBlank((String)throwable.getMessage()) ? throwable.getMessage() : throwable.getClass().getSimpleName());
        }
        if (entry.isWarning() && logger.isWarnEnabled()) {
            if (this.isVerbose()) {
                logger.warn((String)statusMessage, throwable);
            } else {
                logger.warn((String)statusMessage);
            }
        } else if (entry.isError() && logger.isErrorEnabled()) {
            if (this.isVerbose()) {
                logger.error((String)statusMessage, throwable);
            } else {
                logger.error((String)statusMessage);
            }
        } else if (entry.isDebug() && logger.isDebugEnabled()) {
            logger.debug((String)statusMessage);
        } else if (entry.isInfo() && logger.isInfoEnabled()) {
            logger.info((String)statusMessage);
        }
    }

    public String getStatusMsg() {
        StatusEntry lastError = this.getLastError();
        if (lastError != null) {
            return lastError.getMessage();
        }
        StatusEntry lastWarning = this.getLastWarning();
        if (lastWarning != null) {
            return lastWarning.getMessage();
        }
        StatusEntry statusEntry = this.getLastStatusEntry();
        return statusEntry != null ? statusEntry.getMessage() : null;
    }

    public boolean isError() {
        return this.getLastError() != null;
    }

    public CancelException getCancelException() {
        return this.getCancelException(null);
    }

    public CancelException getCancelException(StatusEntry previousToLastError) {
        Throwable cause;
        StatusEntry lastError = this.getLastError();
        if (lastError != null && !lastError.equals(previousToLastError) && (cause = lastError.getException()) instanceof CancelException) {
            return (CancelException)cause;
        }
        return null;
    }

    public Throwable getException() {
        StatusEntry lastError = this.getLastError();
        if (lastError != null) {
            return lastError.getException();
        }
        StatusEntry lastWarning = this.getLastWarning();
        if (lastWarning != null) {
            return lastWarning.getException();
        }
        StatusEntry statusEntry = this.getLastStatusEntry();
        return statusEntry != null ? statusEntry.getException() : null;
    }

    public int getStatusCode() {
        StatusEntry lastError = this.getLastError();
        if (lastError != null) {
            return lastError.getStatusCode();
        }
        StatusEntry lastWarning = this.getLastWarning();
        if (lastWarning != null) {
            return lastWarning.getStatusCode();
        }
        StatusEntry statusEntry = this.getLastStatusEntry();
        return statusEntry != null ? statusEntry.getStatusCode() : -1;
    }

    private void logEntryAndAddEntry(@Nonnull StatusEntry entry, @Nonnull Logger logger) {
        this.addStatusEntry(entry);
        this.logEntry(entry, logger);
    }

    protected void addStatusEntry(StatusEntry entry) {
        while (!this.statusEntries.offer(entry)) {
            this.statusEntries.poll();
        }
        this.lastStatusEntry = entry;
        if (entry.isError()) {
            while (!this.errorEntries.offer(entry)) {
                this.errorEntries.poll();
            }
            this.lastErrorStatusEntry = entry;
        } else if (entry.isWarning()) {
            while (!this.warningEntries.offer(entry)) {
                this.warningEntries.poll();
            }
            this.lastWarningStatusEntry = entry;
        }
    }

    private boolean isActivateLogging() {
        return this.activateLogging;
    }

    public void setActivateLogging(boolean activateLogging) {
        this.activateLogging = activateLogging;
    }

    public void reset() {
        this.statusEntries.clear();
        this.errorEntries.clear();
        this.warningEntries.clear();
        this.activateLogging = true;
    }

    public String toString() {
        return "StatusHolder{activateLogging=" + this.activateLogging + ", statusMessage=" + this.statusEntries + "}, errorMessage=" + this.errorEntries + "}, warningMessage=" + this.warningEntries + "}";
    }

    public void merge(BasicStatusHolder toMerge) {
        for (StatusEntry statusEntry : toMerge.statusEntries) {
            while (!this.statusEntries.offer(statusEntry)) {
                this.statusEntries.poll();
            }
        }
        this.lastStatusEntry = toMerge.statusEntries.peek();
        for (StatusEntry statusEntry : toMerge.errorEntries) {
            while (!this.errorEntries.offer(statusEntry)) {
                this.errorEntries.poll();
            }
        }
        this.lastErrorStatusEntry = toMerge.errorEntries.peek();
        for (StatusEntry statusEntry : toMerge.warningEntries) {
            while (!this.warningEntries.offer(statusEntry)) {
                this.warningEntries.poll();
            }
        }
        this.lastWarningStatusEntry = toMerge.warningEntries.peek();
    }

    public List<StatusEntry> getEntries() {
        return Lists.newArrayList(this.statusEntries);
    }

    public List<StatusEntry> getEntries(StatusEntryLevel level) {
        ArrayList<StatusEntry> result = new ArrayList<StatusEntry>();
        if (level == StatusEntryLevel.ERROR) {
            result.addAll(this.errorEntries);
        } else {
            for (StatusEntry entry : this.statusEntries) {
                if (!level.equals((Object)entry.getLevel())) continue;
                result.add(entry);
            }
        }
        return result;
    }

    public boolean hasWarnings() {
        return !this.warningEntries.isEmpty();
    }

    public boolean hasErrors() {
        return !this.errorEntries.isEmpty();
    }

    public List<StatusEntry> getErrors() {
        return Lists.newArrayList(this.errorEntries);
    }

    public List<StatusEntry> getWarnings() {
        return Lists.newArrayList(this.warningEntries);
    }

    public StatusEntry getMostImportantErrorStatusCode() {
        List<StatusEntry> errorStatusEntries = this.getErrors();
        Optional<StatusEntry> max = errorStatusEntries.stream().filter(entry -> this.isPreferredStatusCode(entry.getStatusCode())).max(StatusEntryComparators.sortByStatusCodeImportency());
        return max.orElseGet(() -> errorStatusEntries.stream().max(StatusEntryComparators.sortByStatusCodeImportency()).orElseThrow(() -> new IllegalArgumentException("No error found")));
    }

    public StatusEntry getMostImportantWarningsStatusCode() {
        List<StatusEntry> warnings = this.getWarnings();
        Optional<StatusEntry> max = warnings.stream().filter(entry -> this.isPreferredStatusCode(entry.getStatusCode())).max(StatusEntryComparators.sortByStatusCodeImportency());
        return max.orElseGet(() -> warnings.stream().max(StatusEntryComparators.sortByStatusCodeImportency()).orElseThrow(() -> new IllegalArgumentException("No warning found")));
    }

    private boolean isPreferredStatusCode(int code) {
        switch (code) {
            case 400: 
            case 403: 
            case 404: 
            case 409: 
            case 500: {
                return true;
            }
        }
        return false;
    }
}

