/*
 * Decompiled with CFR 0.152.
 */
package org.artifactory.api.build;

import com.google.common.collect.Lists;
import java.io.Serializable;
import java.util.Comparator;
import java.util.List;
import org.apache.commons.lang.StringUtils;
import org.artifactory.build.BuildRun;

public class BuildRunComparators {
    public static Comparator<BuildRun> getComparatorFor(List<BuildRun> builds) {
        for (BuildRun build : builds) {
            if (StringUtils.isNumeric((String)build.getNumber())) continue;
            return new BuildNumberStringComparator();
        }
        return new BuildNumberLongComparator();
    }

    public static Comparator<BuildRun> getBuildStartDateComparator() {
        return new BuildStartDateComparator();
    }

    private static class BuildStartDateComparator
    implements Comparator<BuildRun>,
    Serializable {
        private BuildStartDateComparator() {
        }

        @Override
        public int compare(BuildRun build1, BuildRun build2) {
            if (build1 == null || build2 == null) {
                return 0;
            }
            int compareTo = build1.getStartedDate().compareTo(build2.getStartedDate());
            if (compareTo == 0) {
                return BuildRunComparators.getComparatorFor(Lists.newArrayList((Object[])new BuildRun[]{build1, build2})).compare(build1, build2);
            }
            return compareTo;
        }
    }

    private static class BuildNumberStringComparator
    implements Comparator<BuildRun> {
        private BuildNumberStringComparator() {
        }

        @Override
        public int compare(BuildRun build1, BuildRun build2) {
            if (build1 == null || build2 == null) {
                return 0;
            }
            int compareTo = build1.getNumber().compareTo(build2.getNumber());
            if (compareTo == 0) {
                compareTo = build1.getStartedDate().compareTo(build2.getStartedDate());
            }
            return compareTo == 0 ? build1.getName().compareTo(build2.getName()) : compareTo;
        }
    }

    private static class BuildNumberLongComparator
    implements Comparator<BuildRun> {
        private BuildNumberLongComparator() {
        }

        @Override
        public int compare(BuildRun build1, BuildRun build2) {
            if (build1 == null || build2 == null) {
                return 0;
            }
            int compareTo = Long.valueOf(build1.getNumber()).compareTo(Long.valueOf(build2.getNumber()));
            if (compareTo == 0) {
                compareTo = build1.getStartedDate().compareTo(build2.getStartedDate());
            }
            return compareTo == 0 ? build1.getName().compareTo(build2.getName()) : compareTo;
        }
    }
}

