/*
 * Decompiled with CFR 0.152.
 */
package org.artifactory.api.bintray.distribution.reporting;

import com.google.common.collect.HashMultimap;
import com.google.common.collect.Maps;
import com.google.common.collect.Multimap;
import java.util.Collection;
import java.util.Map;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import org.artifactory.api.bintray.distribution.reporting.model.BintrayProductModel;
import org.artifactory.api.bintray.distribution.reporting.model.BintrayRepoModel;
import org.artifactory.api.common.BasicStatusHolder;
import org.artifactory.common.StatusEntry;
import org.artifactory.common.StatusEntryLevel;
import org.artifactory.common.StatusHolder;
import org.artifactory.exception.CancelException;
import org.jfrog.common.BiOptional;
import org.jfrog.common.MultimapCollectors;
import org.slf4j.Logger;

public class DistributionReporter
implements StatusHolder {
    private final Multimap<String, StatusEntry> statusEntries = HashMultimap.create();
    private final Multimap<String, StatusEntry> warningEntries = HashMultimap.create();
    private final Multimap<String, StatusEntry> errorEntries = HashMultimap.create();
    private final Map<String, BintrayRepoModel> repos = Maps.newHashMap();
    private BintrayProductModel product;
    private static final int CODE_OK = 200;
    public static final String GENERAL_MSG = "--general--";
    private boolean activateLogging;
    private StatusEntry lastStatusEntry;
    private StatusEntry lastErrorStatusEntry;
    private StatusEntry lastWarningStatusEntry;

    public DistributionReporter(boolean activateLogging) {
        this.activateLogging = activateLogging;
    }

    public final void debug(String statusMsg, @Nonnull Logger logger) {
        this.addEntryAndLog(new StatusEntry(200, StatusEntryLevel.DEBUG, statusMsg, null), null, logger);
    }

    public final void debug(String fullRepoPath, String statusMsg, Throwable throwable, @Nonnull Logger logger) {
        this.addEntryAndLog(new StatusEntry(200, StatusEntryLevel.DEBUG, statusMsg, throwable), fullRepoPath, logger);
    }

    public final void status(String statusMsg, @Nonnull Logger logger) {
        this.addEntryAndLog(new StatusEntry(200, StatusEntryLevel.INFO, statusMsg, null), null, logger);
    }

    public final void status(String fullRepoPath, String statusMsg, @Nonnull Logger logger) {
        this.addEntryAndLog(new StatusEntry(200, StatusEntryLevel.INFO, statusMsg, null), fullRepoPath, logger);
    }

    public void warn(String fullRepoPath, String statusMsg, int statusCode, @Nonnull Logger logger) {
        this.addEntryAndLog(new StatusEntry(statusCode, StatusEntryLevel.WARNING, statusMsg, null), fullRepoPath, logger);
    }

    public void warn(String statusMsg, int statusCode, Throwable throwable, @Nonnull Logger logger) {
        this.addEntryAndLog(new StatusEntry(statusCode, StatusEntryLevel.WARNING, statusMsg, throwable), GENERAL_MSG, logger);
    }

    public void warn(String statusMsg, int statusCode, @Nonnull Logger logger) {
        this.addEntryAndLog(new StatusEntry(statusCode, StatusEntryLevel.WARNING, statusMsg, null), GENERAL_MSG, logger);
    }

    public void warn(String fullRepoPath, String statusMsg, int statusCode, Throwable throwable, @Nonnull Logger logger) {
        this.addEntryAndLog(new StatusEntry(statusCode, StatusEntryLevel.WARNING, statusMsg, throwable), fullRepoPath, logger);
    }

    public void error(String fullRepoPath, String statusMsg, int statusCode, @Nonnull Logger logger) {
        this.addEntryAndLog(new StatusEntry(statusCode, StatusEntryLevel.ERROR, statusMsg, null), fullRepoPath, logger);
    }

    public void error(String statusMsg, int statusCode, @Nonnull Logger logger) {
        this.addEntryAndLog(new StatusEntry(statusCode, StatusEntryLevel.ERROR, statusMsg, null), GENERAL_MSG, logger);
    }

    public void error(String statusMsg, int statusCode, Throwable throwable, @Nonnull Logger logger) {
        this.addEntryAndLog(new StatusEntry(statusCode, StatusEntryLevel.ERROR, statusMsg, throwable), GENERAL_MSG, logger);
    }

    public void error(String fullRepoPath, String statusMsg, int statusCode, Throwable throwable, @Nonnull Logger logger) {
        this.addEntryAndLog(new StatusEntry(statusCode, StatusEntryLevel.ERROR, statusMsg, throwable), fullRepoPath, logger);
    }

    public void registerRepo(BintrayRepoModel bintrayRepo) {
        BintrayRepoModel existingRepo = this.repos.get(bintrayRepo.repoName);
        if (existingRepo == null) {
            this.repos.put(bintrayRepo.repoName, bintrayRepo);
        } else {
            existingRepo.merge(bintrayRepo);
        }
    }

    public void registerProduct(BintrayProductModel productModel) {
        if (this.product == null) {
            this.product = productModel;
        } else {
            this.product.merge(productModel);
        }
    }

    public void merge(BasicStatusHolder statusHolder) {
        statusHolder.getErrors().forEach(this::addMergedEntry);
        statusHolder.getWarnings().forEach(this::addMergedEntry);
    }

    public boolean hasErrors() {
        return !this.errorEntries.isEmpty();
    }

    public boolean hasWarnings() {
        return !this.warningEntries.isEmpty();
    }

    public Collection<BintrayRepoModel> getRegisteredRepos() {
        return this.repos.values();
    }

    public BintrayProductModel getRegisteredProduct() {
        return this.product;
    }

    public Multimap<String, StatusEntry> getPathErrors() {
        return (Multimap)this.errorEntries.entries().stream().filter(entry -> !((String)entry.getKey()).equals(GENERAL_MSG)).collect(MultimapCollectors.multimapFromEntrySet(HashMultimap::create));
    }

    public Multimap<String, StatusEntry> getGeneralErrors() {
        return (Multimap)this.errorEntries.entries().stream().filter(entry -> ((String)entry.getKey()).equals(GENERAL_MSG)).collect(MultimapCollectors.multimapFromEntrySet(HashMultimap::create));
    }

    public Multimap<String, StatusEntry> getPathWarnings() {
        return (Multimap)this.warningEntries.entries().stream().filter(entry -> !((String)entry.getKey()).equals(GENERAL_MSG)).collect(MultimapCollectors.multimapFromEntrySet(HashMultimap::create));
    }

    public Multimap<String, StatusEntry> getGeneralWarnings() {
        return (Multimap)this.warningEntries.entries().stream().filter(entry -> ((String)entry.getKey()).equals(GENERAL_MSG)).collect(MultimapCollectors.multimapFromEntrySet(HashMultimap::create));
    }

    public boolean isError() {
        return this.lastErrorStatusEntry != null;
    }

    public StatusEntry getLastError() {
        return this.lastErrorStatusEntry;
    }

    public StatusEntry getLastWarning() {
        return this.lastWarningStatusEntry;
    }

    public StatusEntry getLastStatusEntry() {
        return this.lastStatusEntry;
    }

    public String getStatusMsg() {
        StatusEntry latestEntry = this.getLastMostSevere();
        return latestEntry == null ? null : latestEntry.getMessage();
    }

    public Throwable getException() {
        StatusEntry latestEntry = this.getLastMostSevere();
        return latestEntry == null ? null : latestEntry.getException();
    }

    public CancelException getCancelException() {
        return null;
    }

    public int getStatusCode() {
        StatusEntry latestEntry = this.getLastMostSevere();
        return latestEntry == null ? -1 : latestEntry.getStatusCode();
    }

    public boolean isVerbose() {
        return false;
    }

    private void addMergedEntry(StatusEntry err) {
        this.addEntry(new StatusEntry(err.getStatusCode(), err.getLevel(), err.getMessage(), null), GENERAL_MSG);
    }

    private void addEntryAndLog(StatusEntry entry, @Nullable String fullRepoPath, @Nonnull Logger logger) {
        if (this.activateLogging) {
            this.doLogEntry(entry, logger);
        }
        this.addEntry(entry, fullRepoPath);
    }

    private void doLogEntry(@Nonnull StatusEntry entry, @Nonnull Logger logger) {
        if (entry.isError() && logger.isErrorEnabled()) {
            if (entry.getException() != null) {
                logger.error(entry.getMessage(), entry.getException());
            } else {
                logger.error(entry.getMessage());
            }
        } else if (entry.isWarning() && logger.isWarnEnabled()) {
            logger.warn(entry.getMessage());
        } else if (entry.isInfo() && logger.isInfoEnabled()) {
            logger.info(entry.getMessage());
        }
        if (entry.getException() != null && logger.isDebugEnabled()) {
            logger.debug(entry.getMessage(), entry.getException());
        } else if (entry.isDebug() && logger.isDebugEnabled()) {
            logger.debug(entry.getMessage());
        }
    }

    private void addEntry(StatusEntry entry, @Nullable String fullRepoPath) {
        if (fullRepoPath != null) {
            if (entry.isError()) {
                this.insertIfNew(fullRepoPath, entry, this.errorEntries);
                this.lastErrorStatusEntry = entry;
            } else if (entry.isWarning()) {
                this.insertIfNew(fullRepoPath, entry, this.warningEntries);
                this.lastWarningStatusEntry = entry;
            } else if (entry.isInfo()) {
                this.insertIfNew(fullRepoPath, entry, this.statusEntries);
                this.lastStatusEntry = entry;
            }
        }
    }

    private void insertIfNew(@Nonnull String fullRepoPath, StatusEntry newEntry, Multimap<String, StatusEntry> entryMap) {
        BiOptional.of(entryMap.get((Object)fullRepoPath).stream().filter(entry -> entry.getLevel().equals((Object)newEntry.getLevel())).filter(entry -> entry.getMessage().equals(newEntry.getMessage())).filter(entry -> entry.getStatusCode() == newEntry.getStatusCode()).findAny()).ifNotPresent(() -> entryMap.put((Object)fullRepoPath, (Object)newEntry));
    }

    @Nullable
    private StatusEntry getLastMostSevere() {
        StatusEntry lastError = this.getLastError();
        if (lastError != null) {
            return lastError;
        }
        StatusEntry lastWarning = this.getLastWarning();
        if (lastWarning != null) {
            return lastWarning;
        }
        StatusEntry statusEntry = this.getLastStatusEntry();
        return statusEntry != null ? statusEntry : null;
    }
}

