/*
 *
 * Artifactory is a binaries repository manager.
 * Copyright (C) 2018 JFrog Ltd.
 *
 * Artifactory is free software: you can redistribute it and/or modify
 * it under the terms of the GNU Affero General Public License as published by
 * the Free Software Foundation, either version 3 of the License, or
 *  (at your option) any later version.
 *
 * Artifactory is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU Affero General Public License for more details.
 *
 * You should have received a copy of the GNU Affero General Public License
 * along with Artifactory.  If not, see <http://www.gnu.org/licenses/>.
 *
 */

package org.artifactory.api.rest.constant;

import lombok.AccessLevel;
import lombok.NoArgsConstructor;

/**
 * Constants for the {@link GitLfsResource}
 *
 * @author Dan Feldman
 */
@NoArgsConstructor(access = AccessLevel.PRIVATE)
public abstract class GitLfsResourceConstants {

    public static final String PATH_ROOT = "lfs";
    public static final String OBJECTS = "objects";
    public static final String REPO_KEY = "repoKey";
    public static final String OID = "OID";
    public static final String LFS_JSON = "application/vnd.git-lfs+json";
}
