/*
 *
 * Artifactory is a binaries repository manager.
 * Copyright (C) 2018 JFrog Ltd.
 *
 * Artifactory is free software: you can redistribute it and/or modify
 * it under the terms of the GNU Affero General Public License as published by
 * the Free Software Foundation, either version 3 of the License, or
 *  (at your option) any later version.
 *
 * Artifactory is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU Affero General Public License for more details.
 *
 * You should have received a copy of the GNU Affero General Public License
 * along with Artifactory.  If not, see <http://www.gnu.org/licenses/>.
 *
 */

package org.artifactory.api.bintray.distribution;

import org.artifactory.api.bintray.distribution.model.DistributionRepoCreationDetails;

import java.io.IOException;

/**
 * Provides all Bintray OAuth Application actions - creating one and performing auxiliary calls for the repo wizard
 *
 * @author Dan Feldman
 */
public interface BintrayOAuthAppConfigurator {

    /**
     * First call made by the creation wizard, uses the client id and temp secret
     * generated by Bintray to establish trust and acquire a token and a refresh token
     *
     * @param clientId    Client id generated by Bintray
     * @param secret      Client secret generated by Bintray
     * @param code        Code sent back with initial request that should be sent when acquiring token
     * @param scope       Scope of authorization used by this app (generated by Bintray according to org)
     * @param redirectUrl redirect url given in the initial request (must be identical)
     * @return Key of the newly created  {@link org.artifactory.descriptor.repo.BintrayApplicationConfig}
     * that enables working with this
     * Bintray OAuth Application
     */
    DistributionRepoCreationDetails createBintrayAppConfig(String clientId, String secret, String code, String scope,
            String redirectUrl) throws IOException;

    /**
     * Returns UI specific info for create/update repo wizard of {@param repoKey} - org licenses, the bintray Oauth app
     * flow), and is the org premium.
     **/
    DistributionRepoCreationDetails getRepoCreationDetails(String repoKey) throws IOException;
}
