/*
 * Decompiled with CFR 0.152.
 */
package org.artifactory.aql.result;

import java.util.Objects;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Stream;
import org.artifactory.aql.result.AqlResultSetProvider;
import org.artifactory.aql.result.rows.AqlRowResult;
import org.jfrog.common.StreamSupportUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class AqlResultHelper {
    private static final Logger log = LoggerFactory.getLogger(AqlResultHelper.class);

    static <T extends AqlRowResult, P extends AqlResultSetProvider<T>> Stream<P> whileNextStream(P provider, Consumer<Exception> onFinish) {
        if (provider == null) {
            log.warn("Null provider ignored - return empty stream");
            return Stream.empty();
        }
        boolean[] finished = new boolean[]{false};
        Consumer<Exception> finishOnce = e -> {
            if (finished[0]) {
                return;
            }
            if (e != null && log.isDebugEnabled()) {
                log.debug("Failed {} ", (Object)AqlResultHelper.class.getName(), e);
            }
            if (onFinish != null) {
                onFinish.accept((Exception)e);
            }
            finished[0] = true;
        };
        boolean[] closed = new boolean[]{false};
        Runnable closeOnce = () -> {
            if (closed[0]) {
                if (log.isTraceEnabled()) {
                    log.trace("Already closed.");
                }
                return;
            }
            try {
                provider.close();
                closed[0] = true;
                finishOnce.accept(null);
            }
            catch (Exception e) {
                finishOnce.accept(e);
            }
        };
        Function<Integer, AqlResultSetProvider> generator = i -> {
            try {
                if (provider.getResultSet().next()) {
                    return provider;
                }
            }
            catch (Exception e) {
                finishOnce.accept(e);
            }
            closeOnce.run();
            return null;
        };
        return ((Stream)StreamSupportUtils.generateTillNull(generator).onClose(closeOnce)).filter(Objects::nonNull);
    }
}

