/*
 * Decompiled with CFR 0.152.
 */
package org.artifactory.aql.model;

import org.artifactory.aql.model.AqlComparatorEnum;
import org.joda.time.DateTime;
import org.joda.time.Period;
import org.joda.time.ReadablePeriod;
import org.joda.time.format.PeriodFormatter;
import org.joda.time.format.PeriodFormatterBuilder;

public enum AqlRelativeDateComparatorEnum {
    last("$last", AqlComparatorEnum.greater),
    before("$before", AqlComparatorEnum.less);

    public String signature;
    public AqlComparatorEnum aqlComparatorEnum;

    private AqlRelativeDateComparatorEnum(String signature, AqlComparatorEnum aqlComparatorEnum) {
        this.signature = signature;
        this.aqlComparatorEnum = aqlComparatorEnum;
    }

    public static AqlRelativeDateComparatorEnum value(String comparator) {
        for (AqlRelativeDateComparatorEnum comparatorEnum : AqlRelativeDateComparatorEnum.values()) {
            if (!comparatorEnum.signature.equals(comparator)) continue;
            return comparatorEnum;
        }
        return null;
    }

    public long toDate(String value) {
        try {
            PeriodFormatter formatter = new PeriodFormatterBuilder().appendMillis().appendSuffix("millis").appendMillis().appendSuffix("ms").appendMinutes().appendSuffix("minutes").appendMinutes().appendSuffix("mi").appendDays().appendSuffix("days").appendDays().appendSuffix("d").appendMonths().appendSuffix("months").appendMonths().appendSuffix("mo").appendYears().appendSuffix("years").appendYears().appendSuffix("y").appendSeconds().appendSuffix("seconds").appendSeconds().appendSuffix("s").appendWeeks().appendSuffix("weeks").appendWeeks().appendSuffix("w").toFormatter();
            Period period = formatter.parsePeriod(value);
            DateTime now = DateTime.now();
            return now.minus((ReadablePeriod)period).getMillis();
        }
        catch (IllegalArgumentException e) {
            return -1L;
        }
    }
}

