/*
 * Decompiled with CFR 0.152.
 */
package org.artifactory.aql.api.internal;

import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import org.artifactory.aql.AqlException;
import org.artifactory.aql.api.AqlApiElement;
import org.artifactory.aql.api.internal.AqlApiDynamicFieldsDomains;
import org.artifactory.aql.model.AqlComparatorEnum;
import org.artifactory.aql.model.AqlDomainEnum;
import org.artifactory.aql.model.AqlFieldEnum;
import org.artifactory.aql.model.AqlOperatorEnum;
import org.artifactory.aql.model.AqlPhysicalFieldEnum;
import org.artifactory.aql.model.AqlSortTypeEnum;
import org.artifactory.aql.model.AqlVariableTypeEnum;
import org.artifactory.aql.model.DomainSensitiveField;
import org.artifactory.aql.result.rows.AqlRowResult;
import org.artifactory.aql.result.rows.QueryTypes;

public class AqlBase<T extends AqlBase, Y extends AqlRowResult>
implements AqlApiElement {
    protected SortApiElement sortApiElement = new SortApiElement();
    protected LimitApiElement limit = new LimitApiElement();
    protected OffsetApiElement offset = new OffsetApiElement();
    protected FilterApiElement filter = new FilterApiElement();
    protected DomainApiElement domain = new DomainApiElement();
    protected IncludeApiElement include = new IncludeApiElement();

    public AqlBase(Class<? extends AqlRowResult> domainClass, boolean useDefaultResults) {
        QueryTypes annotation = domainClass.getAnnotation(QueryTypes.class);
        AqlDomainEnum domain = annotation.value();
        this.domain.setDomain(domain);
        if (useDefaultResults) {
            ArrayList resultFields = Lists.newArrayList();
            Collections.addAll(resultFields, annotation.physicalFields());
            Collections.addAll(resultFields, annotation.logicalFields());
            for (AqlFieldEnum field : domain.getDefaultResultFields()) {
                this.include.getResultFields().add(new DomainSensitiveField(field, Lists.newArrayList((Object[])new AqlDomainEnum[]{domain})));
            }
            for (AqlFieldEnum field : resultFields) {
                this.include.getResultFields().add(new DomainSensitiveField(field, Lists.newArrayList((Object[])new AqlDomainEnum[]{domain})));
            }
        }
    }

    public static <T extends AqlBase> AndClause<T> and() {
        return new AndClause();
    }

    @SafeVarargs
    public static <T extends AqlBase> AndClause<T> and(AqlApiElement<T> ... elements) {
        return new AndClause<T>(elements);
    }

    @SafeVarargs
    public static <T extends AqlBase> PropertyResultFilterClause<T> propertyResultFilter(AqlApiElement<T> ... elements) {
        return new PropertyResultFilterClause<T>(elements);
    }

    public static <T extends AqlBase> PropertyResultFilterClause<T> propertyResultFilter() {
        return new PropertyResultFilterClause();
    }

    @SafeVarargs
    public static <T extends AqlBase> OrClause<T> or(AqlApiElement<T> ... elements) {
        return new OrClause<T>(elements);
    }

    public static <T extends AqlBase> OrClause<T> or() {
        return new OrClause();
    }

    @SafeVarargs
    public static <T extends AqlBase> FreezeJoin<T> freezeJoin(AqlApiElement<T> ... elements) {
        return new FreezeJoin(elements);
    }

    public static <T extends AqlBase> FreezeJoin<T> freezeJoin() {
        return new FreezeJoin();
    }

    private static String getPath(List<AqlDomainEnum> subDomains) {
        StringBuilder builder = new StringBuilder();
        for (int i = 1; i < subDomains.size(); ++i) {
            AqlDomainEnum domainEnum = subDomains.get(i);
            builder.append(domainEnum.signature).append(".");
        }
        return builder.toString();
    }

    private static String getProprtySensitivePath(List<AqlDomainEnum> subDomains) {
        StringBuilder builder = new StringBuilder();
        for (int i = 1; i < subDomains.size(); ++i) {
            AqlDomainEnum domainEnum = subDomains.get(i);
            if ("property".equals(domainEnum.signature)) {
                builder.append("@");
                continue;
            }
            builder.append(domainEnum.signature).append(".");
        }
        return builder.toString();
    }

    private static String getIdent(int dept) {
        String result = "";
        for (int i = 0; i < dept; ++i) {
            result = result + "  ";
        }
        return result;
    }

    public T filter(AqlApiElement<T> filter) {
        this.filter.setFilter(filter);
        return (T)this;
    }

    public List<AqlApiElement> get() {
        ArrayList elements = Lists.newArrayList();
        elements.add(this.domain);
        elements.add(this.sortApiElement);
        elements.add(this.filter);
        elements.add(this.limit);
        elements.add(this.offset);
        elements.add(this.include);
        return elements;
    }

    @Override
    public boolean isEmpty() {
        return false;
    }

    @Override
    public String toNative(int dept) {
        if (this.domain == null) {
            throw new AqlException("Missing primary domain in query");
        }
        String ident = AqlBase.getIdent(dept + 1);
        StringBuilder builder = new StringBuilder();
        builder.append(this.domain.toNative(dept)).append("find(\n");
        String identPlus = AqlBase.getIdent(dept + 2);
        if (this.filter != null && !this.filter.isEmpty()) {
            builder.append(ident).append("{\n");
            builder.append(identPlus).append(this.filter.toNative(dept + 2)).append("\n");
            builder.append(ident).append("}\n");
        }
        builder.append(")");
        if (this.include != null && !this.include.isEmpty()) {
            builder.append(".\n").append(this.include.toNative(dept));
        }
        if (this.sortApiElement != null && !this.sortApiElement.isEmpty()) {
            builder.append(".\n").append(this.sortApiElement.toNative(dept + 1));
        }
        if (this.offset != null && !this.offset.isEmpty()) {
            builder.append(".\n").append(this.offset.toNative(dept + 1));
        }
        if (this.limit != null && !this.limit.isEmpty()) {
            builder.append(".\n").append(this.limit.toNative(dept + 1));
        }
        return builder.toString();
    }

    public T asc() {
        this.sortApiElement.setSortType(AqlSortTypeEnum.asc);
        return (T)this;
    }

    public T desc() {
        this.sortApiElement.setSortType(AqlSortTypeEnum.desc);
        return (T)this;
    }

    public T addSortElement(AqlApiDynamicFieldsDomains.AqlApiComparator<T> fields) {
        this.sortApiElement.addSortElement(fields);
        return (T)this;
    }

    public T limit(long limit) {
        this.limit.setLimit(limit);
        return (T)this;
    }

    public T offset(int offset) {
        this.offset.setOffset(offset);
        return (T)this;
    }

    public T include(AqlApiDynamicFieldsDomains.AqlApiField ... fields) {
        for (AqlApiDynamicFieldsDomains.AqlApiField field : fields) {
            this.include.getIncludeFields().add(new DomainSensitiveField(field.getFieldEnum(), field.getDomains()));
        }
        return (T)this;
    }

    public static class PropertyCriteriaClause<T extends AqlBase>
    implements AqlApiElement<T> {
        private String string1;
        private AqlComparatorEnum comparator;
        private String string2;
        private List<AqlDomainEnum> subDomains;

        public PropertyCriteriaClause(String key, AqlComparatorEnum comparator, String value, List<AqlDomainEnum> subDomains) {
            this.string1 = key;
            this.comparator = comparator;
            this.string2 = value;
            this.subDomains = subDomains;
        }

        public List<AqlDomainEnum> getSubDomains() {
            return this.subDomains;
        }

        public String getString1() {
            return this.string1;
        }

        public AqlComparatorEnum getComparator() {
            return this.comparator;
        }

        public String getString2() {
            return this.string2;
        }

        @Override
        public List<AqlApiElement<T>> get() {
            return Lists.newArrayList();
        }

        @Override
        public boolean isEmpty() {
            return this.string1 != null && this.string2 != null && this.comparator != null;
        }

        @Override
        public String toNative(int dept) {
            StringBuilder builder = new StringBuilder();
            builder.append("\"").append(AqlBase.getProprtySensitivePath(this.subDomains)).append(this.string1).append("\"");
            builder.append(":{");
            builder.append("\"").append(this.comparator.signature).append("\"");
            builder.append(":");
            if (this.string2 == null) {
                builder.append("null");
            } else {
                builder.append("\"").append(this.string2).append("\"");
            }
            builder.append("}");
            return builder.toString();
        }
    }

    public static class CriteriaClause<T extends AqlBase>
    implements AqlApiElement<T> {
        private AqlPhysicalFieldEnum fieldEnum;
        private List<AqlDomainEnum> subDomains;
        private AqlComparatorEnum comparator;
        private String value;

        public CriteriaClause(AqlPhysicalFieldEnum fieldEnum, List<AqlDomainEnum> subDomains, AqlComparatorEnum comparator, String value) {
            this.fieldEnum = fieldEnum;
            this.subDomains = subDomains;
            this.comparator = comparator;
            this.value = value;
        }

        public List<AqlDomainEnum> getSubDomains() {
            return this.subDomains;
        }

        public AqlPhysicalFieldEnum getFieldEnum() {
            return this.fieldEnum;
        }

        public AqlComparatorEnum getComparator() {
            return this.comparator;
        }

        public String getValue() {
            return this.value;
        }

        @Override
        public List<AqlApiElement<T>> get() {
            return Lists.newArrayList();
        }

        @Override
        public boolean isEmpty() {
            return this.fieldEnum == null || this.comparator == null;
        }

        @Override
        public String toNative(int dept) {
            StringBuilder builder = new StringBuilder();
            builder.append("\"").append(AqlBase.getPath(this.subDomains)).append(this.fieldEnum.getSignature()).append("\"");
            builder.append(":{");
            builder.append("\"").append(this.comparator.signature).append("\"");
            builder.append(":");
            if (this.value == null) {
                builder.append("null");
            } else if (AqlVariableTypeEnum.longInt == this.fieldEnum.getType() || AqlVariableTypeEnum.integer == this.fieldEnum.getType()) {
                builder.append(this.value);
            } else {
                builder.append("\"").append(this.value).append("\"");
            }
            builder.append("}");
            return builder.toString();
        }
    }

    public static class FreezeJoin<T extends AqlBase>
    implements AqlApiElement<T> {
        private final ArrayList<AqlApiElement<T>> elements;

        private FreezeJoin() {
            this.elements = Lists.newArrayList();
        }

        private FreezeJoin(AqlApiElement<T>[] elements) {
            this.elements = Lists.newArrayList((Object[])elements);
        }

        @Override
        public List<AqlApiElement<T>> get() {
            return this.elements;
        }

        @Override
        public boolean isEmpty() {
            return this.elements.isEmpty();
        }

        @Override
        public String toNative(int dept) {
            String ident = AqlBase.getIdent(dept);
            StringBuilder builder = new StringBuilder();
            builder.append("\"").append(AqlOperatorEnum.freezeJoin.signature).append("\"").append(":[\n");
            String identPlus = AqlBase.getIdent(dept + 1);
            for (int i = 0; i < this.elements.size(); ++i) {
                AqlApiElement<T> element = this.elements.get(i);
                builder.append(identPlus).append("{").append(element.toNative(dept + 1)).append("}");
                if (i < this.elements.size() - 1) {
                    builder.append(",");
                }
                builder.append("\n");
            }
            builder.append(ident).append("]");
            return builder.toString();
        }
    }

    public static class PropertyResultFilterClause<T extends AqlBase>
    implements AqlApiElement<T> {
        private final ArrayList<AqlApiElement<T>> elements;

        public PropertyResultFilterClause() {
            this.elements = Lists.newArrayList();
        }

        public PropertyResultFilterClause(AqlApiElement<T>[] elements) {
            this.elements = Lists.newArrayList((Object[])elements);
        }

        @Override
        public List<AqlApiElement<T>> get() {
            return this.elements;
        }

        @Override
        public boolean isEmpty() {
            return this.elements.isEmpty();
        }

        public void append(AqlApiElement<T> aqlApiElement) {
            this.elements.add(aqlApiElement);
        }

        @Override
        public String toNative(int dept) {
            String ident = AqlBase.getIdent(dept);
            StringBuilder builder = new StringBuilder();
            builder.append("\"").append(AqlOperatorEnum.resultFilter.signature).append("\"").append(":[\n");
            String identPlus = AqlBase.getIdent(dept + 1);
            for (int i = 0; i < this.elements.size(); ++i) {
                AqlApiElement<T> element = this.elements.get(i);
                builder.append(identPlus).append("{").append(element.toNative(dept + 1)).append("}");
                if (i < this.elements.size() - 1) {
                    builder.append(",");
                }
                builder.append("\n");
            }
            builder.append(ident).append("]");
            return builder.toString();
        }
    }

    public static class OrClause<T extends AqlBase>
    implements AqlApiElement<T> {
        private final ArrayList<AqlApiElement<T>> orElements;

        public OrClause() {
            this.orElements = Lists.newArrayList();
        }

        public OrClause(AqlApiElement<T>[] elements) {
            this.orElements = Lists.newArrayList((Object[])elements);
        }

        @Override
        public List<AqlApiElement<T>> get() {
            return this.orElements;
        }

        @Override
        public boolean isEmpty() {
            return this.orElements.isEmpty();
        }

        public void append(AqlApiElement aqlApiElement) {
            this.orElements.add(aqlApiElement);
        }

        @Override
        public String toNative(int dept) {
            String ident = AqlBase.getIdent(dept);
            StringBuilder builder = new StringBuilder();
            builder.append("\"").append(AqlOperatorEnum.or.signature).append("\"").append(":[\n");
            String identPlus = AqlBase.getIdent(dept + 1);
            for (int i = 0; i < this.orElements.size(); ++i) {
                AqlApiElement<T> element = this.orElements.get(i);
                builder.append(identPlus).append("{").append(element.toNative(dept + 1)).append("}");
                if (i < this.orElements.size() - 1) {
                    builder.append(",");
                }
                builder.append("\n");
            }
            builder.append(ident).append("]");
            return builder.toString();
        }
    }

    public static class AndClause<T extends AqlBase>
    implements AqlApiElement<T> {
        private final ArrayList<AqlApiElement<T>> andElements;

        public AndClause() {
            this.andElements = Lists.newArrayList();
        }

        public AndClause(AqlApiElement<T>[] elements) {
            this.andElements = Lists.newArrayList((Object[])elements);
        }

        @Override
        public List<AqlApiElement<T>> get() {
            return this.andElements;
        }

        @Override
        public boolean isEmpty() {
            return this.andElements.isEmpty();
        }

        public void append(AqlApiElement<T> aqlApiElement) {
            this.andElements.add(aqlApiElement);
        }

        @Override
        public String toNative(int dept) {
            String ident = AqlBase.getIdent(dept);
            StringBuilder builder = new StringBuilder();
            builder.append("\"").append(AqlOperatorEnum.and.signature).append("\"").append(":[\n");
            String identPlus = AqlBase.getIdent(dept + 1);
            for (int i = 0; i < this.andElements.size(); ++i) {
                AqlApiElement<T> element = this.andElements.get(i);
                builder.append(identPlus).append("{").append(element.toNative(dept + 1)).append("}");
                if (i < this.andElements.size() - 1) {
                    builder.append(",");
                }
                builder.append("\n");
            }
            builder.append(ident).append("]");
            return builder.toString();
        }
    }

    public static class SortApiElement
    implements AqlApiElement {
        private AqlSortTypeEnum sortType = AqlSortTypeEnum.desc;
        private List<DomainSensitiveField> fields = new ArrayList<DomainSensitiveField>();

        public AqlSortTypeEnum getSortType() {
            return this.sortType;
        }

        public void setSortType(AqlSortTypeEnum sortType) {
            this.sortType = sortType;
        }

        public List<DomainSensitiveField> getFields() {
            return this.fields;
        }

        public void addSortElement(AqlApiDynamicFieldsDomains.AqlApiComparator field) {
            this.fields.add(new DomainSensitiveField(field.getFieldEnum(), field.getDomains()));
        }

        public List<AqlApiElement> get() {
            return Lists.newArrayList();
        }

        @Override
        public boolean isEmpty() {
            return this.sortType == null || this.fields == null || this.fields.size() == 0;
        }

        @Override
        public String toNative(int dept) {
            StringBuilder builder = new StringBuilder();
            builder.append("sort({");
            builder.append("\"").append(this.sortType.getAqlName()).append("\"");
            builder.append(":[");
            for (int i = 0; i < this.fields.size(); ++i) {
                DomainSensitiveField field = this.fields.get(i);
                builder.append("\"").append(AqlBase.getPath(field.getSubDomains())).append(field.getField().getSignature()).append("\"");
                if (i >= this.fields.size() - 1) continue;
                builder.append(",");
            }
            builder.append("]");
            builder.append("})");
            return builder.toString();
        }
    }

    public static class OffsetApiElement
    implements AqlApiElement {
        private long offset = 0L;

        public long getOffset() {
            return this.offset;
        }

        public void setOffset(int offset) {
            this.offset = offset;
        }

        public List<AqlApiElement> get() {
            return Lists.newArrayList();
        }

        @Override
        public boolean isEmpty() {
            return this.offset <= 0L || this.offset >= Long.MAX_VALUE;
        }

        @Override
        public String toNative(int dept) {
            StringBuilder builder = new StringBuilder();
            builder.append("offset(");
            builder.append("" + this.offset);
            builder.append(")");
            return builder.toString();
        }
    }

    public static class LimitApiElement
    implements AqlApiElement {
        private long limit = Long.MAX_VALUE;

        public long getLimit() {
            return this.limit;
        }

        public void setLimit(long limit) {
            this.limit = limit;
        }

        public List<AqlApiElement> get() {
            return Lists.newArrayList();
        }

        @Override
        public boolean isEmpty() {
            return this.limit < 0L || this.limit >= Long.MAX_VALUE;
        }

        @Override
        public String toNative(int dept) {
            StringBuilder builder = new StringBuilder();
            builder.append("limit(");
            builder.append("" + this.limit);
            builder.append(")");
            return builder.toString();
        }
    }

    public static class IncludeApiElement
    implements AqlApiElement {
        private List<DomainSensitiveField> includeFields = Lists.newArrayList();
        private List<DomainSensitiveField> resultFields = Lists.newArrayList();

        public List<DomainSensitiveField> getIncludeFields() {
            return this.includeFields;
        }

        public List<DomainSensitiveField> getResultFields() {
            return this.resultFields;
        }

        public List<AqlApiElement> get() {
            return Lists.newArrayList();
        }

        @Override
        public boolean isEmpty() {
            return this.includeFields.size() <= 0;
        }

        @Override
        public String toNative(int dept) {
            StringBuilder builder = new StringBuilder();
            builder.append("include(");
            HashSet<DomainSensitiveField> set = new HashSet<DomainSensitiveField>();
            set.addAll(this.includeFields);
            set.addAll(this.resultFields);
            ArrayList allResultFields = Lists.newArrayList(set);
            for (int i = 0; i < allResultFields.size(); ++i) {
                DomainSensitiveField field = (DomainSensitiveField)allResultFields.get(i);
                builder.append("\"").append(AqlBase.getPath(field.getSubDomains())).append(field.getField().getSignature()).append("\"");
                if (i >= allResultFields.size() - 1) continue;
                builder.append(",");
            }
            builder.append(")");
            return builder.toString();
        }
    }

    public static class DomainApiElement
    implements AqlApiElement {
        private AqlDomainEnum domain;

        public List<AqlApiElement> get() {
            return Lists.newArrayList();
        }

        public AqlDomainEnum getDomain() {
            return this.domain;
        }

        public void setDomain(AqlDomainEnum domain) {
            this.domain = domain;
        }

        @Override
        public boolean isEmpty() {
            return false;
        }

        @Override
        public String toNative(int dept) {
            StringBuilder builder = new StringBuilder();
            for (String subDomain : this.domain.subDomains) {
                builder.append(subDomain).append(".");
            }
            return builder.toString();
        }
    }

    public static class FilterApiElement
    implements AqlApiElement {
        private AqlApiElement filter;

        public List<AqlApiElement> get() {
            return Lists.newArrayList((Object[])new AqlApiElement[]{this.filter});
        }

        @Override
        public boolean isEmpty() {
            return this.filter == null || this.filter.isEmpty();
        }

        public AqlApiElement getFilter() {
            return this.filter;
        }

        public void setFilter(AqlApiElement filter) {
            this.filter = filter;
        }

        @Override
        public String toNative(int dept) {
            if (this.filter == null) {
                return "";
            }
            return this.filter.toNative(dept);
        }
    }
}

