/*
 * Decompiled with CFR 0.152.
 */
package org.artifactory.api.storage;

import org.jfrog.storage.common.StorageUnit;

public class StorageQuotaInfo {
    private final int diskSpaceLimitPercentage;
    private final int diskSpaceWarningPercentage;
    private long freeSpace;
    private long totalSpace;
    private long usedSpace;
    private double dataUsagePercentage;

    public StorageQuotaInfo(long freeSpace, long totalSpace, long usedSpace, int diskSpaceLimitPercentage, int diskSpaceWarningPercentage) {
        this.freeSpace = freeSpace;
        this.totalSpace = totalSpace;
        this.usedSpace = usedSpace;
        this.diskSpaceLimitPercentage = diskSpaceLimitPercentage;
        this.diskSpaceWarningPercentage = diskSpaceWarningPercentage;
        this.dataUsagePercentage = (double)usedSpace / (double)totalSpace * 100.0;
    }

    public boolean isLimitReached() {
        return this.dataUsagePercentage >= (double)this.diskSpaceLimitPercentage;
    }

    public boolean isWarningLimitReached() {
        return this.dataUsagePercentage >= (double)this.diskSpaceWarningPercentage;
    }

    public int getDiskSpaceLimitPercentage() {
        return this.diskSpaceLimitPercentage;
    }

    public int getDataUsagePercentage() {
        return (int)this.dataUsagePercentage;
    }

    public int getDiskSpaceWarningPercentage() {
        return this.diskSpaceWarningPercentage;
    }

    public String getReadableFreeSpace() {
        return StorageUnit.toReadableString((long)this.freeSpace);
    }

    public String getReadableTotalSpace() {
        return StorageUnit.toReadableString((long)this.totalSpace);
    }

    public String getReadableUsedSpace() {
        return StorageUnit.toReadableString((long)this.usedSpace);
    }

    public String getErrorMessage() {
        return String.format("Datastore disk space is too high: Max limit: %s%%, Used: %s%%, Total: %s, Used: %s, Available: %s", this.getDiskSpaceLimitPercentage(), this.getDataUsagePercentage(), this.getReadableTotalSpace(), this.getReadableUsedSpace(), this.getReadableFreeSpace());
    }

    public String getWarningMessage() {
        return String.format("Datastore disk is too high: Warning limit: %s%%, Used: %s%%, Total: %s, Used: %s, Available: %s", this.getDiskSpaceWarningPercentage(), this.getDataUsagePercentage(), this.getReadableTotalSpace(), this.getReadableUsedSpace(), this.getReadableFreeSpace());
    }
}

