/*
 * Decompiled with CFR 0.152.
 */
package org.artifactory.api.security.access;

import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import org.artifactory.api.security.access.TokenInfo;
import org.artifactory.api.security.access.TokenSpec;
import org.jfrog.access.common.ServiceId;
import org.jfrog.access.common.SubjectFQN;

public class UserTokenSpec
extends TokenSpec<UserTokenSpec> {
    private static final int MAX_USERNAME_LENGTH = 58;
    private final String username;

    private UserTokenSpec(@Nullable String username) {
        this.username = username;
    }

    @Nonnull
    public static UserTokenSpec create(@Nullable String username) {
        return new UserTokenSpec(username);
    }

    @Nullable
    public String getUsername() {
        return this.username;
    }

    @Override
    public SubjectFQN createSubject(ServiceId serviceId) {
        this.validateUsername();
        return new SubjectFQN(serviceId, new String[]{"users", this.username});
    }

    private void validateUsername() {
        UserTokenSpec.requireNonBlank(this.username, "username is required");
        if (this.username.length() > 58) {
            throw new IllegalArgumentException("username length exceeds maximum length of 58 characters");
        }
    }

    public static boolean isUserToken(TokenInfo tokenInfo) {
        return UserTokenSpec.isUserTokenSubject(tokenInfo.getSubject());
    }

    public static boolean isUserTokenSubject(String subject) {
        return SubjectFQN.isUserTokenSubject((String)subject);
    }

    @Nonnull
    public static String extractUsername(String subject) {
        return SubjectFQN.extractUsername((String)subject);
    }
}

