/*
 * Decompiled with CFR 0.152.
 */
package org.artifactory.api.security.access;

import java.util.Collections;
import java.util.List;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import org.apache.commons.lang.StringUtils;
import org.jfrog.access.common.ServiceId;
import org.jfrog.access.common.SubjectFQN;

public abstract class TokenSpec<T extends TokenSpec> {
    private List<String> scope;
    private List<String> audience;
    private Boolean refreshable;
    private Long expiresIn;

    public T scope(List<String> scope) {
        this.scope = scope;
        return this.self();
    }

    public T audience(List<String> audience) {
        this.audience = audience;
        return this.self();
    }

    public T refreshable(Boolean refreshable) {
        this.refreshable = refreshable;
        return this.self();
    }

    public T expiresIn(Long expiresIn) {
        this.expiresIn = expiresIn;
        return this.self();
    }

    public T noExpiry() {
        this.expiresIn = 0L;
        return this.self();
    }

    private T self() {
        return (T)this;
    }

    public abstract SubjectFQN createSubject(ServiceId var1);

    @Nonnull
    public List<String> getScope() {
        return this.scope == null ? Collections.emptyList() : this.scope;
    }

    @Nonnull
    public List<String> getAudience() {
        return this.audience == null ? Collections.emptyList() : this.audience;
    }

    @Nullable
    public Boolean getRefreshable() {
        return this.refreshable;
    }

    public boolean isRefreshable() {
        return Boolean.TRUE.equals(this.refreshable);
    }

    @Nullable
    public Long getExpiresIn() {
        return this.expiresIn;
    }

    protected static String requireNonBlank(String value, String message) {
        if (StringUtils.isBlank((String)value)) {
            throw new IllegalArgumentException(message);
        }
        return value;
    }
}

