/*
 * Decompiled with CFR 0.152.
 */
package org.artifactory.api.search.gavc;

import org.apache.commons.lang.StringUtils;
import org.artifactory.api.search.SearchControlsBase;

public class GavcSearchControls
extends SearchControlsBase {
    private String groupId;
    private String artifactId;
    private String version;
    private String classifier;

    public GavcSearchControls() {
    }

    public GavcSearchControls(GavcSearchControls gavcSearchControls) {
        this.groupId = gavcSearchControls.groupId;
        this.artifactId = gavcSearchControls.artifactId;
        this.version = gavcSearchControls.version;
        this.classifier = gavcSearchControls.classifier;
        this.selectedRepoForSearch = gavcSearchControls.selectedRepoForSearch;
        this.setLimitSearchResults(gavcSearchControls.isLimitSearchResults());
    }

    public String getGroupId() {
        return this.groupId;
    }

    public void setGroupId(String groupId) {
        this.groupId = groupId;
    }

    public String getArtifactId() {
        return this.artifactId;
    }

    public void setArtifactId(String artifactId) {
        this.artifactId = artifactId;
    }

    public String getVersion() {
        return this.version;
    }

    public void setVersion(String version) {
        this.version = version;
    }

    public String getClassifier() {
        return this.classifier;
    }

    public void setClassifier(String classifier) {
        this.classifier = classifier;
    }

    @Override
    public boolean isEmpty() {
        return this.isEmpty(this.groupId) && this.isEmpty(this.artifactId) && this.isEmpty(this.version) && this.isEmpty(this.classifier);
    }

    @Override
    public boolean isWildcardsOnly() {
        String expression = StringUtils.remove((String)this.getSearchExpression(), (char)'-');
        return StringUtils.isBlank((String)expression) || this.isWildcardsOnly(expression);
    }

    public String getSearchExpression() {
        String expression;
        StringBuilder sb = new StringBuilder();
        if (!this.isEmpty(this.groupId)) {
            sb.append(this.groupId).append("-");
        }
        if (!this.isEmpty(this.artifactId)) {
            sb.append(this.artifactId).append("-");
        }
        if (!this.isEmpty(this.version)) {
            sb.append(this.version).append("-");
        }
        if (!this.isEmpty(this.classifier)) {
            sb.append(this.classifier);
        }
        if ((expression = sb.toString()).endsWith("-")) {
            expression = expression.substring(0, expression.length() - 1);
        }
        return expression;
    }

    private boolean isEmpty(String field) {
        return StringUtils.isEmpty((String)field);
    }
}

