/*
 * Decompiled with CFR 0.152.
 */
package org.artifactory.api.search;

import org.apache.commons.lang.StringUtils;
import org.artifactory.api.search.ItemSearchResult;
import org.artifactory.fs.ItemInfo;
import org.jfrog.client.util.PathUtils;

public abstract class SearchResultBase
implements ItemSearchResult {
    public final ItemInfo itemInfo;

    public SearchResultBase(ItemInfo itemInfo) {
        this.itemInfo = itemInfo;
    }

    @Override
    public ItemInfo getItemInfo() {
        return this.itemInfo;
    }

    @Override
    public String getName() {
        String itemName = this.itemInfo.getName();
        if (StringUtils.isEmpty((String)itemName)) {
            return this.getRepoKey();
        }
        return itemName;
    }

    public String getRelDirPath() {
        return PathUtils.getParent((String)this.itemInfo.getRelPath());
    }

    public String getRepoKey() {
        return this.itemInfo.getRepoKey();
    }

    public String getRelativePath() {
        return this.itemInfo.getRelPath();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof SearchResultBase)) {
            return false;
        }
        SearchResultBase base = (SearchResultBase)o;
        return !(this.itemInfo == null ? base.itemInfo != null : !this.itemInfo.equals(base.itemInfo));
    }

    public int hashCode() {
        return this.itemInfo != null ? this.itemInfo.hashCode() : 0;
    }
}

