/*
 * Decompiled with CFR 0.152.
 */
package org.artifactory.api.search;

import com.google.common.collect.Lists;
import java.util.List;
import java.util.regex.Pattern;
import javax.annotation.Nullable;
import org.apache.commons.lang.StringUtils;
import org.artifactory.api.search.SearchControls;
import org.artifactory.api.security.AuthorizationService;
import org.artifactory.common.ConstantValues;

public abstract class SearchControlsBase
implements SearchControls {
    private static Pattern wildcardsOnlyPattern = Pattern.compile("(\\*|\\?)+");
    private boolean limitSearchResults = true;
    protected List<String> selectedRepoForSearch;

    @Override
    @Nullable
    public List<String> getSelectedRepoForSearch() {
        return this.selectedRepoForSearch;
    }

    public void setSelectedRepoForSearch(List<String> selectedRepoForSearch) {
        this.selectedRepoForSearch = selectedRepoForSearch;
    }

    @Override
    public boolean isLimitSearchResults() {
        return this.limitSearchResults;
    }

    public void setLimitSearchResults(boolean limitSearchResults) {
        this.limitSearchResults = limitSearchResults;
    }

    public void setLimitSearchResultsByPolicy(AuthorizationService authorizationService) {
        this.limitSearchResults = ConstantValues.searchLimitAnonymousUserOnly.getBoolean() ? authorizationService.isAnonymous() : !authorizationService.isAdmin();
    }

    @Override
    public void resetResultLimit() {
        this.limitSearchResults = true;
    }

    @Override
    public boolean isSpecificRepoSearch() {
        return this.selectedRepoForSearch != null && !this.selectedRepoForSearch.isEmpty();
    }

    public void addRepoToSearch(String repoKey) {
        if (this.selectedRepoForSearch == null) {
            this.selectedRepoForSearch = Lists.newArrayList();
        }
        this.selectedRepoForSearch.add(repoKey);
    }

    public boolean isWildcardsOnly(String str) {
        return StringUtils.isBlank((String)str) || wildcardsOnlyPattern.matcher(str).matches();
    }
}

