/*
 * Decompiled with CFR 0.152.
 */
package org.artifactory.api.rest.artifact;

import com.google.common.collect.Lists;
import java.util.List;
import javax.xml.bind.annotation.XmlType;

public class RepairPathConflictsResult {
    public String message;
    public long numConflicts;
    public long numRepaired;
    public List<PathConflict> conflicts;

    public RepairPathConflictsResult(String message) {
        this.message = message;
    }

    public RepairPathConflictsResult(List<PathConflict> conflicts, String message) {
        this.conflicts = conflicts;
        this.numConflicts = conflicts.size();
        this.message = message;
    }

    @XmlType(name="PathConflict", propOrder={"path", "conflicts"})
    public static class PathConflict {
        private String path;
        private List<String> conflicts = Lists.newArrayListWithCapacity((int)2);

        public PathConflict() {
        }

        public PathConflict(String path) {
            this.path = path;
            this.conflicts = Lists.newArrayList();
        }

        public void add(String path) {
            this.conflicts.add(path);
        }

        public String getPath() {
            return this.path;
        }

        public List<String> getConflicts() {
            return this.conflicts;
        }
    }
}

