/*
 * Decompiled with CFR 0.152.
 */
package org.artifactory.api.repo;

import org.artifactory.api.repo.BaseBrowsableItem;
import org.artifactory.checksum.ChecksumType;
import org.artifactory.fs.FileInfo;
import org.artifactory.fs.ItemInfo;
import org.artifactory.repo.InternalRepoPathFactory;
import org.artifactory.repo.RepoPath;

public class BrowsableItem
extends BaseBrowsableItem {
    private static final long serialVersionUID = 1L;
    private RepoPath repoPath;

    public BrowsableItem(String name, boolean folder, long created, long lastModified, long size, RepoPath repoPath) {
        super(name, folder, created, lastModified, size);
        this.repoPath = repoPath;
    }

    public static <T extends ItemInfo> BrowsableItem getItem(T itemInfo) {
        if (itemInfo.isFolder()) {
            return new BrowsableItem(itemInfo.getName(), true, itemInfo.getCreated(), itemInfo.getLastModified(), 0L, itemInfo.getRepoPath());
        }
        return new BrowsableItem(itemInfo.getName(), false, itemInfo.getCreated(), itemInfo.getLastModified(), ((FileInfo)itemInfo).getSize(), itemInfo.getRepoPath());
    }

    public static BrowsableItem getChecksumItem(BrowsableItem browsableItem, ChecksumType checksumType, long checksumValueLength) {
        String checksumItemName = browsableItem.getName() + checksumType.ext();
        RepoPath repoPath = InternalRepoPathFactory.create((String)browsableItem.getRepoKey(), (String)(browsableItem.getRelativePath() + checksumType.ext()));
        return new BrowsableItem(checksumItemName, false, browsableItem.getCreated(), browsableItem.getLastModified(), checksumValueLength, repoPath);
    }

    @Override
    public RepoPath getRepoPath() {
        return this.repoPath;
    }

    @Override
    public String getRepoKey() {
        return this.repoPath.getRepoKey();
    }

    @Override
    public String getRelativePath() {
        return this.repoPath.getPath();
    }

    @Override
    public int compareTo(BaseBrowsableItem o) {
        if (o.name.equals("..") && this.name.equals("..") && this.isFolder() && o.isFolder()) {
            return 0;
        }
        if (this.name.equals("..") || this.isFolder() && !o.isFolder()) {
            return -1;
        }
        if (o.name.equals("..") || !this.isFolder() && o.isFolder()) {
            return 1;
        }
        return this.name.compareTo(o.name);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof BrowsableItem)) {
            return false;
        }
        BrowsableItem that = (BrowsableItem)o;
        return this.name != null ? this.name.equals(that.name) : that.name == null;
    }

    public int hashCode() {
        return this.name != null ? this.name.hashCode() : 0;
    }
}

