/*
 * Decompiled with CFR 0.152.
 */
package org.artifactory.api.replication;

import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.atomic.AtomicLong;
import org.artifactory.api.replication.ReplicationStatistics;

public class ReplicationStatisticsHelper {
    private AtomicInteger artifactsReplicated;
    private AtomicInteger artifactsFailed;
    private AtomicLong bytesTransferred = new AtomicLong();
    private AtomicLong replicationDurationMillis;

    public ReplicationStatisticsHelper() {
        this.artifactsReplicated = new AtomicInteger();
        this.artifactsFailed = new AtomicInteger();
        this.replicationDurationMillis = new AtomicLong();
    }

    public ReplicationStatistics calc() {
        return ReplicationStatistics.builder().averageTransferRateInKbps(this.averageTransferRate()).totalBytesTransferred(this.bytesTransferred.get()).artifactsReplicatedSuccessfully(this.artifactsReplicated.get()).artifactsFailedToReplicate(this.artifactsFailed.get()).timeSpentReplicatingFilesInMillis(this.replicationDurationMillis.get()).build();
    }

    private Integer averageTransferRate() {
        if (this.bytesTransferred.get() == 0L || this.artifactsReplicated.get() == 0 || this.replicationDurationMillis.get() == 0L) {
            return 0;
        }
        long bytesPerMillis = this.bytesTransferred.get() / this.replicationDurationMillis.get();
        return StrictMath.toIntExact(bytesPerMillis);
    }

    public void incrementReplicatedArtifacts() {
        this.artifactsReplicated.incrementAndGet();
    }

    public void incrementBytesTransferred(long bytesTransferred) {
        this.bytesTransferred.addAndGet(bytesTransferred);
    }

    public void incrementReplicationDurationMillis(long replicationDurationMillis) {
        this.replicationDurationMillis.addAndGet(replicationDurationMillis);
    }

    public void incrementArtifactsFailedToReplicate() {
        this.artifactsFailed.incrementAndGet();
    }
}

