/*
 * Decompiled with CFR 0.152.
 */
package org.artifactory.api.config;

import com.thoughtworks.xstream.annotations.XStreamAlias;
import java.io.File;
import org.artifactory.api.common.ImportExportStatusHolder;
import org.artifactory.api.config.ImportExportSettingsImpl;
import org.artifactory.sapi.common.BaseSettings;
import org.artifactory.sapi.common.ImportSettings;
import org.artifactory.sapi.fs.MetadataReader;
import org.artifactory.version.ArtifactoryVersion;

@XStreamAlias(value="import-settings")
public class ImportSettingsImpl
extends ImportExportSettingsImpl
implements ImportSettings {
    private final SharedInfo info;
    private boolean excludeArtifactBundles = false;
    private boolean excludeBuildInfoRepo = false;

    public ImportSettingsImpl(File baseDir) {
        this(baseDir, new ImportExportStatusHolder());
    }

    public ImportSettingsImpl(File baseDir, ImportExportStatusHolder statusHolder) {
        super(baseDir, statusHolder);
        this.info = new SharedInfo();
    }

    public ImportSettingsImpl(File baseDir, ImportSettings settings) {
        this(baseDir, settings, (ImportExportStatusHolder)settings.getStatusHolder());
    }

    public ImportSettingsImpl(File baseDir, ImportSettings settings, ImportExportStatusHolder statusHolder) {
        super(baseDir, (BaseSettings)settings, statusHolder);
        this.info = ((ImportSettingsImpl)settings).info;
    }

    public ArtifactoryVersion getExportVersion() {
        return this.info.exportVersion;
    }

    public void setExportVersion(ArtifactoryVersion exportVersion) {
        this.info.exportVersion = exportVersion;
    }

    public MetadataReader getMetadataReader() {
        return this.info.metadataReader;
    }

    public void setMetadataReader(MetadataReader metadataReader) {
        this.info.metadataReader = metadataReader;
    }

    public boolean isIndexMarkedArchives() {
        return this.info.indexMarkedArchives;
    }

    public void setIndexMarkedArchives(boolean indexMarkedArchives) {
        this.info.indexMarkedArchives = indexMarkedArchives;
    }

    public boolean isExcludeArtifactBundles() {
        return this.excludeArtifactBundles;
    }

    public void setExcludeArtifactBundles(boolean excludeArtifactBundles) {
        this.excludeArtifactBundles = excludeArtifactBundles;
    }

    public boolean isExcludeBuildInfoRepo() {
        return this.excludeBuildInfoRepo;
    }

    public void setExcludeBuildInfoRepo(boolean excludeBuildInfoRepo) {
        this.excludeBuildInfoRepo = excludeBuildInfoRepo;
    }

    private static class SharedInfo {
        private ArtifactoryVersion exportVersion;
        private MetadataReader metadataReader;
        private boolean indexMarkedArchives;

        private SharedInfo() {
        }
    }
}

